package net.inventive_mods.inventive_inventory.util.widgets;

import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8133;

public class DirectionalLayoutWidget implements class_8133 {
    private final class_7845 grid;
    private final DirectionalLayoutWidget.DisplayAxis axis;
    private int currentIndex = 0;

    private DirectionalLayoutWidget(DirectionalLayoutWidget.DisplayAxis axis) {
        this(0, 0, axis);
    }

    public DirectionalLayoutWidget(int x, int y, DirectionalLayoutWidget.DisplayAxis axis) {
        this.grid = new class_7845(x, y);
        this.axis = axis;
    }

    public DirectionalLayoutWidget spacing(int spacing) {
        this.axis.setSpacing(this.grid, spacing);
        return this;
    }

    public class_7847 copyPositioner() {
        return this.grid.method_46457();
    }

    public <T extends class_8021> T add(T widget, class_7847 positioner) {
        return this.axis.add(this.grid, widget, this.currentIndex++, positioner);
    }

    public <T extends class_8021> T add(T widget) {
        return this.add(widget, this.copyPositioner());
    }

    public <T extends class_8021> T add(T widget, Consumer<class_7847> callback) {
        return this.axis.add(this.grid, widget, this.currentIndex++, class_156.method_654(this.copyPositioner(), callback));
    }

    @Override
    public void method_48227(Consumer<class_8021> consumer) {
        this.grid.method_48227(consumer);
    }

    @Override
    public void method_48222() {
        this.grid.method_48222();
    }

    @Override
    public int method_25368() {
        return this.grid.method_25368();
    }

    @Override
    public int method_25364() {
        return this.grid.method_25364();
    }

    @Override
    public void method_46421(int x) {
        this.grid.method_46421(x);
    }

    @Override
    public void method_46419(int y) {
        this.grid.method_46419(y);
    }

    @Override
    public int method_46426() {
        return this.grid.method_46426();
    }

    @Override
    public int method_46427() {
        return this.grid.method_46427();
    }

    public static DirectionalLayoutWidget vertical() {
        return new DirectionalLayoutWidget(DirectionalLayoutWidget.DisplayAxis.VERTICAL);
    }

    public static DirectionalLayoutWidget horizontal() {
        return new DirectionalLayoutWidget(DirectionalLayoutWidget.DisplayAxis.HORIZONTAL);
    }

    public enum DisplayAxis {
        HORIZONTAL,
        VERTICAL;

        void setSpacing(class_7845 grid, int spacing) {
            switch (this) {
                case HORIZONTAL:
                    grid.method_48635(spacing);
                    break;
                case VERTICAL:
                    grid.method_48636(spacing);
            }
        }

        public <T extends class_8021> T add(class_7845 grid, T widget, int index, class_7847 positioner) {
            return switch (this) {
                case HORIZONTAL -> grid.method_46455(widget, 0, index, positioner);
                case VERTICAL -> grid.method_46455(widget, index, 0, positioner);
            };
        }
    }
}
