package net.inventive_mods.inventive_inventory.util.widgets;

import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.inventive_mods.inventive_inventory.config.options.ConfigOption;
import net.inventive_mods.inventive_inventory.config.screens.ConfigScreen;
import net.inventive_mods.inventive_inventory.config.screens.widgets.ConfigTextWidget;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_7842;

public abstract class ScreenTab extends CustomListWidget {

    public ScreenTab(class_310 client, int width, ConfigScreen screen) {
        super(client, width, screen);
    }

    protected void addTitle(class_2561 title) {
        if (client == null) return;
        class_7842 text = new ConfigTextWidget(310, client.field_1772.field_2000, title.method_27661().method_10862(class_2583.field_24360.method_10982(true)), client.field_1772);
        this.addWidgetEntry(text, null);
    }

    protected void addWidget(ConfigOption<?> option) {
        if (client == null) return;
        this.addWidgetEntry(option.createLabel(), option.asWidget());
    }

    protected void addCenteredWidget(class_339 widget) {
        if (client == null) return;
        this.addWidgetEntry(widget, null);
    }

    protected void addEmptyRow() {
        if (client == null) return;
        class_7842 textWidget = new class_7842(class_2561.method_43473(), InventiveInventory.getClient().field_1772);
        this.addWidgetEntry(textWidget, textWidget);
    }

    protected void onClose() {}

    protected void position(int width, TabbedThreePartsLayoutWidget layout) {
        this.setDimensions(width, layout.getContentHeight());
        this.method_48229(0, layout.method_48998());
        this.refreshScroll();
    }

    protected void refreshScroll() {
        this.setScrollAmount(this.getScrollAmount());
    }
}
