package net.inventive_mods.inventive_inventory.features.automatic_refilling;

import net.inventive_mods.inventive_inventory.config.ConfigManager;
import net.inventive_mods.inventive_inventory.config.enums.automatic_refilling.ToolReplacementBehaviour;
import net.inventive_mods.inventive_inventory.config.enums.automatic_refilling.ToolReplacementPriority;
import net.inventive_mods.inventive_inventory.features.locked_slots.LockedSlotsHandler;
import net.inventive_mods.inventive_inventory.util.InteractionHandler;
import net.inventive_mods.inventive_inventory.util.slots.PlayerSlots;
import net.inventive_mods.inventive_inventory.util.slots.SlotRange;
import net.inventive_mods.inventive_inventory.util.slots.SlotTypes;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class AutomaticRefillingHandler {
    private static final List<class_1792> EMPTIES = List.of(class_1802.field_8550, class_1802.field_8469, class_1802.field_8428);
    private static final List<class_1792> BUCKETS = List.of(class_1802.field_8550, class_1802.field_8705, class_1802.field_8187, class_1802.field_27876, class_1802.field_8103, class_1802.field_8108, class_1802.field_8714, class_1802.field_8666, class_1802.field_8478, class_1802.field_28354, class_1802.field_37533);
    private static class_1799 mainHandStack = class_1799.field_8037;
    private static class_1799 offHandStack = class_1799.field_8037;
    public static boolean keysPressed = false;
    private static int selectedSlot;
    private static boolean runOffHand = true;

    public static void setMainHandStack(class_1799 stack) {
        mainHandStack = stack.method_7972();
    }

    public static void setOffHandStack(class_1799 stack) {
        offHandStack = stack.method_7972();
    }

    public static int getSelectedSlot() {
        return selectedSlot;
    }

    public static void setSelectedSlot(int selectedSlot) {
        AutomaticRefillingHandler.selectedSlot = selectedSlot;
    }

    public static boolean shouldRun() {
        if (!AutomaticRefillingHandler.keysPressed) return false;
        if (mainHandStack.method_7960() || class_1799.method_7973(mainHandStack, InteractionHandler.getMainHandStack()) || mainHandStack.method_7947() > 1) return false;
        if (ConfigManager.AUTOMATIC_REFILLING_IGNORE_BUCKETS.is(true) && BUCKETS.contains(InteractionHandler.getMainHandStack().method_7909())) return false;
        return !mainHandStack.method_7963() || ToolReplacementBehaviour.isValid(mainHandStack);
    }

    public static boolean shouldRunOffHand() {
        if (!runOffHand) {
            runOffHand = true;
            return false;
        }
        if (!AutomaticRefillingHandler.keysPressed) return false;
        if (offHandStack.method_7960() || class_1799.method_7973(offHandStack, InteractionHandler.getOffHandStack()) || offHandStack.method_7947() > 1) return false;
        if (ConfigManager.AUTOMATIC_REFILLING_IGNORE_BUCKETS.is(true) && BUCKETS.contains(InteractionHandler.getOffHandStack().method_7909())) return false;
        return !offHandStack.method_7963() || ToolReplacementBehaviour.isValid(offHandStack);
    }

    public static void runMainHand() {
        List<Integer> sameItemSlots = getSameItemSlots(mainHandStack);

        int emptiesSlot = InteractionHandler.getSelectedSlot();
        if (!sameItemSlots.isEmpty()) {
            if (class_1723.method_36211(sameItemSlots.getFirst())) {
                InteractionHandler.setSelectedSlot(sameItemSlots.getFirst() - class_1661.field_30638);
            } else {
                if (ConfigManager.AUTOMATIC_REFILLING_IGNORE_LOCKED_SLOTS.is(false) || !LockedSlotsHandler.getLockedSlots().contains(InteractionHandler.getSelectedSlot())) {
                    InteractionHandler.swapStacks(sameItemSlots.getFirst(), InteractionHandler.getSelectedSlot());
                    emptiesSlot = sameItemSlots.getFirst();
                }
            }
        } else runOffHand = false;

        mainHandStack = class_1799.field_8037;
        if (EMPTIES.contains(InteractionHandler.getStackFromSlot(emptiesSlot).method_7909())) mergeEmpties(emptiesSlot);
    }

    public static void runOffHand() {
        List<Integer> sameItemSlots = getSameItemSlots(offHandStack);

        int emptiesSlot = class_1723.field_30812;
        if (!sameItemSlots.isEmpty()) {
            InteractionHandler.swapStacks(sameItemSlots.getFirst(), class_1723.field_30812);
            emptiesSlot = sameItemSlots.getFirst();
        }

        offHandStack = class_1799.field_8037;
        if (EMPTIES.contains(InteractionHandler.getStackFromSlot(emptiesSlot).method_7909())) mergeEmpties(emptiesSlot);
    }

    private static List<Integer> getSameItemSlots(class_1799 handStack) {
        SlotRange slotRange = PlayerSlots.get().append(SlotTypes.HOTBAR).exclude(InteractionHandler.getSelectedSlot());
        slotRange = ConfigManager.AUTOMATIC_REFILLING_IGNORE_LOCKED_SLOTS.is(true) ? slotRange.exclude(SlotTypes.LOCKED_SLOT) : slotRange;
        Stream<Integer> sameItemSlotsStream = slotRange.stream()
                .filter(slot -> {
                    class_1799 stack = InteractionHandler.getStackFromSlot(slot);
                    if (handStack.method_7963()) {
                        if (isPlainItem(handStack) && isPlainItem(stack)) {
                            if (getToolType(handStack).equals(getToolType(stack))) {
                                return ((ConfigManager.TOOL_REPLACEMENT_BEHAVIOUR.is(ToolReplacementBehaviour.KEEP_TOOL) && stack.method_7936() - stack.method_7919() > 1) || ConfigManager.TOOL_REPLACEMENT_BEHAVIOUR.is(ToolReplacementBehaviour.BREAK_TOOL));
                            }
                            return false;
                        }
                        return class_1799.method_7984(stack, handStack) &&
                                ((ConfigManager.TOOL_REPLACEMENT_BEHAVIOUR.is(ToolReplacementBehaviour.KEEP_TOOL) && stack.method_7936() - stack.method_7919() > 1) || ConfigManager.TOOL_REPLACEMENT_BEHAVIOUR.is(ToolReplacementBehaviour.BREAK_TOOL));
                    } return class_1799.method_7984(handStack, stack);
                });

        if (handStack.method_7963()) {
            if (ConfigManager.TOOL_REPLACEMENT_PRIORITY.is(ToolReplacementPriority.MATERIAL)) {
                sameItemSlotsStream = sameItemSlotsStream
                        .sorted(Comparator.comparing(slot -> InteractionHandler.getStackFromSlot(slot).method_7936(), Comparator.reverseOrder()));
            } else if (ConfigManager.TOOL_REPLACEMENT_PRIORITY.is(ToolReplacementPriority.DURABILITY)) {
                sameItemSlotsStream = sameItemSlotsStream
                        .sorted(Comparator.comparing(slot -> InteractionHandler.getStackFromSlot(slot).method_7936() - InteractionHandler.getStackFromSlot(slot).method_7919()));
            }
        } else {
            sameItemSlotsStream = sameItemSlotsStream
                    .sorted(Comparator.comparing(slot -> InteractionHandler.getStackFromSlot(slot).method_7947()));
        }

        List<Integer> sameItemSlots = new ArrayList<>(sameItemSlotsStream.toList());
        SlotRange hotbarSlotRange = SlotRange.of(sameItemSlots).exclude(SlotTypes.INVENTORY);
        SlotRange inventorySlotRange = SlotRange.of(sameItemSlots).exclude(SlotTypes.HOTBAR);
        sameItemSlots.removeAll(!hotbarSlotRange.isEmpty() ? inventorySlotRange : hotbarSlotRange);
        return sameItemSlots;
    }

    private static void mergeEmpties(int itemSlot) {
        SlotRange slotRange = PlayerSlots.get().append(SlotTypes.HOTBAR).exclude(itemSlot);
        slotRange = ConfigManager.AUTOMATIC_REFILLING_IGNORE_LOCKED_SLOTS.is(true) ? slotRange.exclude(SlotTypes.LOCKED_SLOT) : slotRange;
        List<Integer> sameItemSlots = slotRange.stream()
                .filter(slot -> InteractionHandler.getStackFromSlot(slot).method_7909().equals(InteractionHandler.getStackFromSlot(itemSlot).method_7909()))
                .filter(slot -> InteractionHandler.getStackFromSlot(slot).method_7947() < InteractionHandler.getStackFromSlot(slot).method_7914())
                .sorted(Comparator.comparing(slot -> InteractionHandler.getStackFromSlot(slot).method_7947(), Comparator.reverseOrder()))
                .toList();
        if (!sameItemSlots.isEmpty()) {
            InteractionHandler.leftClickStack(itemSlot);
            InteractionHandler.leftClickStack(sameItemSlots.getFirst());
        }
    }

    private static String getToolType(class_1799 stack) {
        String[] id = stack.method_41409().method_55840().split(":");
        String itemId = id[id.length - 1];
        String[] parts = itemId.split("_");
        return parts[parts.length - 1];
    }

    private static boolean isPlainItem(class_1799 stack) {
        return stack.method_7909().getClass().equals(class_1792.class);
    }

    public static void reset() {
        mainHandStack = class_1799.field_8037;
        offHandStack = class_1799.field_8037;
    }
}
