package net.inventive_mods.inventive_inventory.util.tooltips;

import net.inventive_mods.inventive_inventory.features.profiles.Profile;
import net.inventive_mods.inventive_inventory.keys.KeyRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_304;
import net.minecraft.class_6880;
import java.util.ArrayList;
import java.util.List;

public class TooltipBuilder {
    private final static String TOOLTIP_TRANSLATION_KEY = "profiles.screen.tooltip.inventive_inventory.";

    public static List<class_2561> of(TooltipType type, Profile profile) {
        if (type == TooltipType.NAME) return buildName(profile);
        else if (type == TooltipType.ITEM) return buildItem(profile);
        else if (type == TooltipType.UNKNOWN) return buildUnknown(profile);
        else if (type == TooltipType.PLUS) return buildPlus();
        else return new ArrayList<>();
    }

    private static List<class_2561> buildName(Profile profile) {
        List<class_2561> textList = new ArrayList<>();
        addTitle(class_2561.method_30163(profile.getName()), class_124.field_1065, textList);
        addKey(profile, textList);
        return textList;
    }

    private static List<class_2561> buildItem(Profile profile) {
        List<class_2561> textList = new ArrayList<>();
        addTitle(class_2561.method_30163(profile.getDisplayStack().method_7964().getString()), class_124.field_1075, textList);
        if (profile.getDisplayStack().method_7942()) {
            for (class_6880<class_1887> entry : profile.getDisplayStack().method_58657().method_57534()) {
                textList.add(class_1887.method_8179(entry, class_1890.method_8225(entry, profile.getDisplayStack())));
            }
            textList.add(class_2561.method_43473());
        }
        addKey(profile, textList);
        return textList;
    }

    private static List<class_2561> buildUnknown(Profile profile) {
        List<class_2561> textList = new ArrayList<>();
        addTitle(class_2561.method_43471(TOOLTIP_TRANSLATION_KEY + "unnamed"), class_124.field_1080, textList);
        addKey(profile, textList);
        return textList;
    }

    private static List<class_2561> buildPlus() {
        List<class_2561> textList = new ArrayList<>();
        textList.add(class_2561.method_43471(TOOLTIP_TRANSLATION_KEY + "plus.1"));
        textList.add(class_2561.method_43473());
        textList.add(class_2561.method_43471(TOOLTIP_TRANSLATION_KEY + "plus.2"));
        return textList;
    }

    private static void addTitle(class_2561 title, class_124 formatting, List<class_2561> textList) {
        textList.add(title.method_27661().method_10862(class_2583.field_24360.method_10977(formatting)));
    }

    private static void addKey(Profile profile, List<class_2561> textList) {
        if (profile.getKey() != null) {
            class_304 keyBinding = KeyRegistry.getByTranslationKey(profile.getKey());
            if (keyBinding != null) textList.add(class_2561.method_30163(class_2561.method_43471(TOOLTIP_TRANSLATION_KEY + "key").getString() + ": " + keyBinding.method_16007().getString()));
        }
    }
}
