package net.inventive_mods.inventive_inventory.features.locked_slots.mixins;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.inventive_mods.inventive_inventory.config.ConfigManager;
import net.inventive_mods.inventive_inventory.features.locked_slots.LockedSlotsHandler;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1703.class)
public class MixinItemQuickMove {

    @ModifyExpressionValue(method = "insertItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isEmpty()Z", ordinal = 1))
    private boolean isEmptyAndLockedSlot(boolean original, @Local(ordinal = 2) int i) {
        if (InventiveInventory.getClient().method_1542() && ConfigManager.QUICK_MOVE_INTO_LOCKED_SLOTS.is(false)) {
            return original || LockedSlotsHandler.getLockedSlots().contains(i);
        } return original;
    }

    @ModifyExpressionValue(method = "insertItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isEmpty()Z", ordinal = 3))
    private boolean notEmptyAndLockedSlot(boolean original, @Local(ordinal = 2) int i) {
        if (InventiveInventory.getClient().method_1542() && ConfigManager.QUICK_MOVE_INTO_LOCKED_SLOTS.is(false)) {
            return original && !LockedSlotsHandler.getLockedSlots().contains(i);
        } return original;
    }

    @ModifyExpressionValue(method = "internalOnSlotClick", at = @At(value = "INVOKE", target = "Lnet/minecraft/screen/slot/Slot;hasStack()Z", ordinal = 3))
    private boolean preventPickupAll(boolean original, @Local(ordinal = 1) class_1735 slot) {
        if (InventiveInventory.getClient().method_1542()) {
            return original && !LockedSlotsHandler.getLockedSlots().contains(slot.field_7874);
        } return original;
    }
}
