package net.inventive_mods.inventive_inventory.keys.keybindfix;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import net.inventive_mods.inventive_inventory.config.ConfigManager;
import net.inventive_mods.inventive_inventory.features.profiles.ProfileHandler;
import net.inventive_mods.inventive_inventory.keys.KeyRegistry;
import net.inventive_mods.inventive_inventory.keys.keybindfix.mixins.MixinIKeyBindingAccessor;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KeybindFixer {

    private static final Multimap<class_3675.class_306, class_304> keyFixMap = ArrayListMultimap.create();

    public static void putKey(class_3675.class_306 key, class_304 keyBinding) {
        keyFixMap.put(key, keyBinding);
    }

    public static void clearMap() {
        keyFixMap.clear();
    }

    public static boolean checkProfileKeys(class_3675.class_306 key) {
        List<class_304> profileKeys = new ArrayList<>(Arrays.asList(KeyRegistry.profileKeys));
        profileKeys.removeAll(ProfileHandler.getAvailableProfileKeys());
        List<class_304> keyBindings = keyFixMap.get(key).stream().toList();
        for (class_304 keyBind : keyBindings) {
            if (profileKeys.contains(keyBind)) {
                if (KeyRegistry.loadProfileKey.method_1434() || ConfigManager.FAST_LOAD.is(true)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static void onKeyPressed(class_3675.class_306 key, class_304 finalBinding, class_304 baseBinding) {
        if (finalBinding != baseBinding) return;
        for (class_304 keyBinding : keyFixMap.get(key)) {
            if (keyBinding == null || keyBinding == baseBinding) continue;
            MixinIKeyBindingAccessor keyBindingAccessor = (MixinIKeyBindingAccessor) keyBinding;
            keyBindingAccessor.setTimesPressed(keyBindingAccessor.getTimesPressed() + 1);
        }
    }

    public static void setKeyPressed(class_3675.class_306 key, boolean pressed, class_304 finalBinding, class_304 baseBinding) {
        if (finalBinding != baseBinding) return;
        for (class_304 keyBinding : keyFixMap.get(key)) {
            if (keyBinding == null || keyBinding == baseBinding) continue;
            keyBinding.method_23481(pressed);
        }
    }
}
