package net.inventive_mods.inventive_inventory.features.item_counter;

import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.inventive_mods.inventive_inventory.config.ConfigManager;
import net.inventive_mods.inventive_inventory.config.enums.Status;
import net.inventive_mods.inventive_inventory.config.enums.item_counter.ItemCounterMode;
import net.inventive_mods.inventive_inventory.util.Drawer;
import net.inventive_mods.inventive_inventory.util.InteractionHandler;
import net.inventive_mods.inventive_inventory.util.slots.PlayerSlots;
import net.inventive_mods.inventive_inventory.util.slots.SlotTypes;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3916;
import net.minecraft.class_9779;
import java.util.List;

public class ItemCounterHudElement implements HudElement {
    public static class_2960 IDENTIFIER = class_2960.method_60655(InventiveInventory.MOD_ID, "item_counter_hud_element");

    @Override
    public void render(class_332 context, class_9779 tickCounter) {
        if (ConfigManager.ITEM_COUNTER_STATUS.is(Status.DISABLED) || (InventiveInventory.getPlayer() != null && InventiveInventory.getPlayer().method_68878()) || InventiveInventory.getScreenHandler() instanceof class_3916)
            return;

        List<class_1799> inventory = (ConfigManager.ITEM_COUNTER_IGNORE_LOCKED_SLOTS.is(true) ? PlayerSlots.get().exclude(SlotTypes.LOCKED_SLOT) : PlayerSlots.get()).stream().map(InteractionHandler::getStackFromSlot).toList();
        int slotX = context.method_51421() / 2 - 90 + 2;
        int slotY = context.method_51443() - 16 - 3;
        for (Integer slot : PlayerSlots.get(SlotTypes.HOTBAR)) {
            class_1799 stack = InteractionHandler.getStackFromSlot(slot);
            if (!stack.method_7960() && (ConfigManager.ITEM_COUNTER_MODE.is(ItemCounterMode.COMPLETE_HOTBAR) || ConfigManager.ITEM_COUNTER_MODE.is(ItemCounterMode.ONLY_SELECTED_SLOT) && InteractionHandler.getSelectedSlot() == slot)) {
                int count = inventory.stream()
                        .filter(itemStack -> class_1799.method_7984(itemStack, stack))
                        .mapToInt(class_1799::method_7947)
                        .sum();
                Drawer.drawItemCounter(context, slotX, slotY, count, stack);
            }
            slotX += 20;
        }
    }
}
