package net.inventive_mods.inventive_inventory.features.sorting;

import net.inventive_mods.inventive_inventory.config.ConfigManager;
import net.inventive_mods.inventive_inventory.util.InteractionHandler;
import net.inventive_mods.inventive_inventory.util.slots.SlotRange;
import net.minecraft.class_1799;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class SortingHelper {

    public static void mergeItemStacks(SlotRange slotRange) {
        Integer emptySlot = null;
        SlotRange followingSlots = slotRange.copy();
        for (int slot : slotRange) {
            followingSlots.remove((Integer) slot);
            class_1799 stack = InteractionHandler.getStackFromSlot(slot);
            if (stack.method_7960() && emptySlot == null) emptySlot = slot;
            if (!stack.method_7960() && stack.method_7947() < stack.method_7914()) {
                for (int followingSlot : followingSlots) {
                    class_1799 followingStack = InteractionHandler.getStackFromSlot(followingSlot);
                    if (class_1799.method_7984(stack, followingStack) && followingStack.method_7947() < followingStack.method_7914()) {
                        InteractionHandler.swapStacks(followingSlot, slot);
                    } else if (class_1799.method_7984(stack, InteractionHandler.getCursorStack())) {
                        InteractionHandler.leftClickStack(slot);
                    }
                }
            }
        }
        if (InteractionHandler.isCursorFull()) {
            if (emptySlot != null) {
                InteractionHandler.leftClickStack(emptySlot);
            } else if (class_1799.method_7984(InteractionHandler.getStackFromSlot(slotRange.getLast()), InteractionHandler.getCursorStack())) {
                InteractionHandler.leftClickStack(slotRange.getLast());
            }
        }
    }

    public static void sortItemStacks(SlotRange inventorySlots) {
        List<Integer> sortedSlots = new ArrayList<>(getSortedSlots(inventorySlots));
        for (int i = 0; i < sortedSlots.size(); i++) {
            if (sortedSlots.get(i).equals(inventorySlots.get(i))) continue;
            if (class_1799.method_7984(InteractionHandler.getStackFromSlot(sortedSlots.get(i)), InteractionHandler.getCursorStack())) {
                for (int slot : inventorySlots) {
                    if (!class_1799.method_7984(InteractionHandler.getStackFromSlot(slot), InteractionHandler.getCursorStack()) && slot != sortedSlots.get(i)) {
                        InteractionHandler.leftClickStack(slot);
                        InteractionHandler.swapStacks(sortedSlots.get(i), inventorySlots.get(i));
                        InteractionHandler.leftClickStack(slot);
                        break;
                    }
                }
            } else {
                InteractionHandler.swapStacks(sortedSlots.get(i), inventorySlots.get(i));
            }
            if (sortedSlots.contains(inventorySlots.get(i))) {
                sortedSlots.set(sortedSlots.indexOf(inventorySlots.get(i)), sortedSlots.get(i));
            }
            sortedSlots.set(i, inventorySlots.get(i));
        }
    }

    public static void adjustCursorStack(SlotRange slotRange, class_1799 targetStack) {
        if (targetStack.method_7947() > InteractionHandler.getCursorStack().method_7947()) {
            if (InteractionHandler.getCursorStack().method_7960()) handleEmptyCursorStack(slotRange, targetStack);
            else handleFullCursorStack(slotRange, targetStack);
            rearrangeSlots(slotRange);
        }
    }

    private static void handleEmptyCursorStack(SlotRange slotRange, class_1799 targetStack) {
        List<Integer> sameStackSlots = findSameStacks(slotRange, targetStack);
        Collections.reverse(sameStackSlots);
        InteractionHandler.leftClickStack(sameStackSlots.getFirst());
        if (InteractionHandler.getCursorStack().method_7947() > targetStack.method_7947()) {
            while (InteractionHandler.getCursorStack().method_7947() > targetStack.method_7947()) {
                InteractionHandler.rightClickStack(sameStackSlots.getFirst());
            }
        } else if (InteractionHandler.getCursorStack().method_7947() < targetStack.method_7947()) {
            InteractionHandler.leftClickStack(sameStackSlots.getFirst());
            InteractionHandler.leftClickStack(sameStackSlots.get(1));
            while (InteractionHandler.getStackFromSlot(sameStackSlots.getFirst()).method_7947() < targetStack.method_7947()) {
                InteractionHandler.rightClickStack(sameStackSlots.getFirst());
            }
            InteractionHandler.leftClickStack(sameStackSlots.get(1));
            InteractionHandler.leftClickStack(sameStackSlots.getFirst());
        }
    }

    private static void handleFullCursorStack(SlotRange slotRange, class_1799 targetStack) {
        List<Integer> sameStackSlots = findSameStacks(slotRange, targetStack);
        Collections.reverse(sameStackSlots);
        slotRange.removeAll(sameStackSlots);
        if (slotRange.isEmpty()) return;

        InteractionHandler.leftClickStack(slotRange.getFirst());
        InteractionHandler.leftClickStack(sameStackSlots.getFirst());

        while (targetStack.method_7947() > InteractionHandler.getStackFromSlot(slotRange.getFirst()).method_7947()) {
            InteractionHandler.rightClickStack(slotRange.getFirst());
        }
        InteractionHandler.leftClickStack(sameStackSlots.getFirst());
        InteractionHandler.leftClickStack(slotRange.getFirst());
    }

    private static void rearrangeSlots(SlotRange slotRange) {
        SlotRange followingSlots = slotRange.copy();
        for (int slot : slotRange) {
            followingSlots.remove((Integer) slot);
            if (InteractionHandler.getStackFromSlot(slot).method_7960()) {
                for (int followingSlot : followingSlots) {
                    InteractionHandler.swapStacks(followingSlot, slot);
                    InteractionHandler.leftClickStack(followingSlot);
                    slot = followingSlot;
                }
                return;
            }
        }
    }

    private static List<Integer> getSortedSlots(SlotRange slotRange) {
        return slotRange.stream()
                .filter(slot -> !InteractionHandler.getStackFromSlot(slot).method_7960())
                .sorted(ConfigManager.SORTING_MODE.getValue().getComparator())
                .toList();
    }

    private static List<Integer> findSameStacks(SlotRange slotRange, class_1799 targetStack) {
        return new ArrayList<>(slotRange.stream()
                .filter(slot -> class_1799.method_7984(InteractionHandler.getStackFromSlot(slot), targetStack))
                .toList());
    }
}
