package net.inventive_mods.inventive_inventory;

import net.fabricmc.api.ClientModInitializer;
import net.inventive_mods.inventive_inventory.features.item_counter.ItemCounterHandler;
import net.inventive_mods.inventive_inventory.commands.CommandRegistry;
import net.inventive_mods.inventive_inventory.config.ConfigManager;
import net.inventive_mods.inventive_inventory.events.ConnectionEvents;
import net.inventive_mods.inventive_inventory.events.TickEvents;
import net.inventive_mods.inventive_inventory.keys.KeyRegistry;
import net.minecraft.class_1703;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5455;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

public class InventiveInventory implements ClientModInitializer {
    public static final String MOD_ID = "inventive_inventory";
    public static final String MOD_NAME = "Inventive Inventory";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_NAME);

    @Override
    public void onInitializeClient() {
        try {
            ConfigManager.init();
            KeyRegistry.register();
            ConnectionEvents.register();
            TickEvents.register();
            CommandRegistry.register();
            ItemCounterHandler.register();
            LOGGER.info(MOD_NAME + " initialized successfully!");
        } catch (IOException e) {
            LOGGER.error("Couldn't create config files", e);
            LOGGER.error(MOD_NAME + " could not be initialized correctly!");
            LOGGER.error("DELETE THE " + InventiveInventory.MOD_ID + " CONFIG DIRECTORY!");
        }
    }

    public static class_310 getClient() {
        return class_310.method_1551();
    }

    public static class_746 getPlayer() {
        return getClient().field_1724;
    }

    public static class_638 getWorld() {
        return getClient().field_1687;
    }

    public static class_437 getScreen() {
        return getClient().field_1755;
    }

    public static class_636 getInteractionManager() {
        return getClient().field_1761;
    }

    public static class_5455 getRegistryManager() {
        return getWorld().method_30349();
    }

    public static class_1703 getScreenHandler() {
        if (getPlayer() == null) return null;
        return getPlayer().field_7512;
    }

    public static String getWorldName() {
        String worldName = "";
        if (InventiveInventory.getClient().method_1542() && InventiveInventory.getClient().method_1576() != null) {
            worldName = InventiveInventory.getClient().method_1576().method_27728().method_150();
        } else {
            if (InventiveInventory.getClient().method_1562() != null) {
                String address = InventiveInventory.getClient().method_1562().method_48296().method_10755().toString();
                if (address.contains("/")) worldName = address.split("/")[0];
                else worldName = address;
            }
        }
        return worldName;
    }
}
