package net.inventive_mods.inventive_inventory.config.options.buttons;

import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.inventive_mods.inventive_inventory.config.enums.accessors.Translatable;
import net.inventive_mods.inventive_inventory.config.options.ConfigOption;
import net.minecraft.class_2561;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;

public class EnumButtonOption<E extends Enum<E>> extends ConfigOption<E> {
    private final Class<E> enumClass;

    public EnumButtonOption(String tab, String translationKey, E defaultValue) {
        super(tab, translationKey, defaultValue);
        this.enumClass = defaultValue.getDeclaringClass();
    }

    protected void cycle() {
        E[] values = enumClass.getEnumConstants();
        this.setValue(values[(this.getValue().ordinal() + 1) % values.length]);
    }

    @Override
    public void setValue(@Nullable String value) {
        for (E config : enumClass.getEnumConstants()) {
            if (config.toString().equalsIgnoreCase(value)) {
                this.setValue(config);
                return;
            } else if (config instanceof Translatable) {
                if (((Translatable) config).getButtonText().getString().equalsIgnoreCase(value)) {
                    this.setValue(config);
                    return;
                }
            }
        }
    }

    @Override
    public class_5676<?> asWidget() {
        return class_5676.method_32606(ConfigOption::getValueAsText)
                .method_32618(value -> class_7919.method_47407(class_2561.method_43471("config." + this.tab + ".button.tooltip." + InventiveInventory.MOD_ID + "." + ((Translatable) value).getTranslationKey())))
                .method_32616()
                .method_32624(Arrays.stream(this.enumClass.getEnumConstants()).toArray()).method_32619(this.getValue())
                .method_57720(class_2561.method_43473(), (button, value) -> this.cycle());
    }

}
