package net.inventive_mods.inventive_inventory.features.locked_slots;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.inventive_mods.inventive_inventory.config.ConfigManager;
import net.inventive_mods.inventive_inventory.context.ContextManager;
import net.inventive_mods.inventive_inventory.context.Contexts;
import net.inventive_mods.inventive_inventory.util.FileHandler;
import net.inventive_mods.inventive_inventory.util.InteractionHandler;
import net.inventive_mods.inventive_inventory.util.ScreenCheck;
import net.inventive_mods.inventive_inventory.util.slots.PlayerSlots;
import net.inventive_mods.inventive_inventory.util.slots.SlotTypes;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class LockedSlotsHandler {
    private static final String LOCKED_SLOTS_FILE = "locked_slots.json";
    public static final Path LOCKED_SLOTS_PATH = ConfigManager.CONFIG_PATH.resolve(LOCKED_SLOTS_FILE);
    private static final List<class_1799> savedInventory = new ArrayList<>();
    private static final List<class_1799> savedHandlerInventory = new ArrayList<>();
    public static boolean shouldAdd;
    public static boolean shouldInit;
    public static boolean schedulerStarted;
    private static LockedSlots lockedSlots = LockedSlots.empty();

    public static final int HOVER_COLOR = 0x66FF0000;
    public static final int LOCKED_HOVER_COLOR = 0xFF8B0000;

    public static void toggle(int slot) {
        ContextManager.setContext(Contexts.LOCKED_SLOTS);
        if (PlayerSlots.get().append(SlotTypes.HOTBAR).contains(slot)) {
            lockedSlots = getLockedSlots();
            if (lockedSlots.contains(slot)) {
                lockedSlots.remove(((Integer) slot));
                shouldAdd = false;
            } else {
                lockedSlots.add(slot);
                shouldAdd = true;
            }
            save();
        }
    }

    public static void dragToggle(int slot) {
        if (PlayerSlots.get().append(SlotTypes.HOTBAR).contains(slot)) {
            lockedSlots = getLockedSlots();
            if (shouldAdd) {
                if (!lockedSlots.contains(slot)) lockedSlots.add(slot);
            } else lockedSlots.remove(Integer.valueOf(slot));
            save();
        }
    }

    public static void init() {
        reset();
        shouldInit = false;
        JsonElement jsonFile = FileHandler.get(LOCKED_SLOTS_PATH);
        JsonArray lockedSlotsJson = new JsonArray();
        if (jsonFile.isJsonObject() && jsonFile.getAsJsonObject().has(InventiveInventory.getWorldName())) {
            lockedSlotsJson = jsonFile.getAsJsonObject().getAsJsonArray(InventiveInventory.getWorldName());
        }
        for (JsonElement slot : lockedSlotsJson.getAsJsonArray()) {
            lockedSlots.add(slot.getAsInt());
        }
    }

    public static void reset() {
        lockedSlots.clear();
        savedInventory.clear();
        savedHandlerInventory.clear();
    }

    public static LockedSlots getLockedSlots() {
        return lockedSlots.adjust();
    }

    public static void adjustInventory() {
        List<class_1799> currentInventory = new ArrayList<>(InventiveInventory.getPlayer().method_31548().field_7547);
        if (savedInventory.isEmpty()) return;
        boolean itemTaken = isItemTaken(currentInventory);
        boolean itemMoved = isItemMoved(itemTaken);

        ContextManager.setContext(Contexts.LOCKED_SLOTS);
        if (ConfigManager.PICKUP_INTO_LOCKED_SLOTS.is(false) && itemTaken && !itemMoved) {
            rearrange(currentInventory, InteractionHandler::dropItem);
        } else if (ConfigManager.QUICK_MOVE_INTO_LOCKED_SLOTS.is(false) && itemMoved) {
            rearrange(currentInventory, (slot, times) -> InteractionHandler.quickMove(slot));
        }
        ContextManager.setContext(Contexts.INIT);
    }

    public static void setSavedInventory() {
        savedInventory.clear();
        for (class_1799 stack : InventiveInventory.getPlayer().method_31548().field_7547) savedInventory.add(stack.method_7972());
        savedInventory.add(InteractionHandler.getCursorStack().method_7972());
    }

    public static void setSavedHandlerInventory() {
        savedHandlerInventory.clear();
        if (!ScreenCheck.isNone()) {
            for (int i = 0; i < InventiveInventory.getScreenHandler().field_7761.size(); i++) {
                savedHandlerInventory.add(InteractionHandler.getStackFromSlot(i).method_7972());
            }
        }
    }

    private static Map<class_1792, Integer> getItemCountMap(List<class_1799> inventory) {
        return inventory.stream().collect(Collectors.toMap(class_1799::method_7909, class_1799::method_7947, Integer::sum));
    }

    private static boolean isItemTaken(List<class_1799> currentInventory) {
        Map<class_1792, Integer> currentCountMap = getItemCountMap(currentInventory);
        Map<class_1792, Integer> savedCountMap = getItemCountMap(savedInventory);
        return currentCountMap.entrySet().stream()
                .anyMatch(entry -> entry.getValue() > savedCountMap.getOrDefault(entry.getKey(), 0));
    }

    private static boolean isItemMoved(boolean tookItem) {
        List<class_1799> currentHandlerInventory = new ArrayList<>();
        for (int i = 0; i < InventiveInventory.getScreenHandler().field_7761.size(); i++) {
            currentHandlerInventory.add(InteractionHandler.getStackFromSlot(i).method_7972());
        }
        Map<class_1792, Integer> currentCountMap = getItemCountMap(currentHandlerInventory);
        Map<class_1792, Integer> savedCountMap = getItemCountMap(savedHandlerInventory);
        return tookItem && currentCountMap.entrySet().stream()
                .allMatch(entry -> entry.getValue().equals(savedCountMap.getOrDefault(entry.getKey(), 0)));
    }

    private static void rearrange(List<class_1799> currentInventory, BiConsumer<Integer, Integer> func) {
        if (savedInventory.isEmpty()) return;
        LockedSlots lockedSlots = LockedSlotsHandler.getLockedSlots();
        int i = 0;
        for (int invSlot : PlayerSlots.get(SlotTypes.HOTBAR).append(SlotTypes.INVENTORY)) {
            class_1799 currentStack = currentInventory.get(i);
            class_1799 savedStack = savedInventory.get(i);
            i++;
            if (!lockedSlots.contains(invSlot) || class_1799.method_7973(currentStack, savedStack)) continue;
            List<Integer> suitableSlots = PlayerSlots.get(SlotTypes.HOTBAR).append(SlotTypes.INVENTORY).exclude(SlotTypes.LOCKED_SLOT).stream()
                    .filter(slot -> {
                        class_1799 stack = InteractionHandler.getStackFromSlot(slot);
                        return stack.method_7960() || class_1799.method_7984(stack, currentStack) && stack.method_7947() < stack.method_7914();
                    })
                    .sorted(Comparator.comparing((Integer slot) -> InteractionHandler.getStackFromSlot(slot).method_7947(), Comparator.reverseOrder()))
                    .toList();
            if (!suitableSlots.isEmpty()) {
                InteractionHandler.leftClickStack(invSlot);
                for (int slot : suitableSlots) {
                    class_1799 stack = InteractionHandler.getStackFromSlot(slot);
                    while (InteractionHandler.getCursorStack().method_7947() > savedStack.method_7947()) {
                        if (stack.method_7947() < stack.method_7914()) InteractionHandler.rightClickStack(slot);
                        else break;
                    }
                }
                InteractionHandler.leftClickStack(invSlot);
            }
            if (InteractionHandler.getStackFromSlot(invSlot).method_7947() > savedStack.method_7947()) {
                func.accept(invSlot, InteractionHandler.getStackFromSlot(invSlot).method_7947() - savedStack.method_7947());
            }
        }
    }

    private static void save() {
        lockedSlots = lockedSlots.unadjust();
        JsonArray lockedSlotsJson = new JsonArray();
        for (int lockedSlot : lockedSlots) lockedSlotsJson.add(lockedSlot);
        JsonObject jsonObject = FileHandler.get(LOCKED_SLOTS_PATH).isJsonObject() ? FileHandler.get(LOCKED_SLOTS_PATH).getAsJsonObject() : new JsonObject();
        jsonObject.remove(InventiveInventory.getWorldName());
        jsonObject.add(InventiveInventory.getWorldName(), lockedSlotsJson);
        FileHandler.write(LOCKED_SLOTS_PATH, jsonObject);
    }

    public static void startScheduler() {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        Runnable task = new Runnable() {
            private int iteration = 0;

            @Override
            public void run() {
                if (iteration > 10) {
                    LockedSlotsHandler.shouldInit = true;
                    scheduler.shutdown();
                }
                iteration++;
            }
        };
        scheduler.scheduleAtFixedRate(task, 0, 50, TimeUnit.MILLISECONDS);
        schedulerStarted = true;
    }
}
