package net.inventive_mods.inventive_inventory.config.screens.tabs;

import net.inventive_mods.inventive_inventory.config.screens.ConfigScreen;
import net.inventive_mods.inventive_inventory.config.screens.widgets.ConfigProfileTitleWidget;
import net.inventive_mods.inventive_inventory.config.screens.widgets.ConfigProfileWidget;
import net.inventive_mods.inventive_inventory.features.profiles.Profile;
import net.inventive_mods.inventive_inventory.features.profiles.ProfileHandler;
import net.inventive_mods.inventive_inventory.util.widgets.ScreenTab;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_7842;
import java.util.ArrayList;
import java.util.List;

public class ConfigProfilesTab extends ScreenTab {
    public List<class_2561> availableKeys = new ArrayList<>();

    public ConfigProfilesTab(class_310 client, int width, ConfigScreen screen) {
        super(client, width, screen);
        availableKeys = getAvailableKeys();
        if (ProfileHandler.getProfiles().isEmpty()) {
            this.addCenteredWidget(new class_7842(this.field_22758, this.field_22759, class_2561.method_43471("config.profiles.text.inventive_inventory.no_profiles"), this.client.field_1772));
        } else {
            this.initTitleBar();
            this.initEntries();
        }
    }

    private void initTitleBar() {
        this.addCenteredWidget(new ConfigProfileTitleWidget(this.field_22758, 20));
    }

    private void initEntries() {
        int i = 1;
        for (Profile profile : ProfileHandler.getProfiles()) {
            this.addCenteredWidget(new ConfigProfileWidget(this.field_22758, 20, i, profile, this));
            i++;
        }
    }

    private List<class_2561> getAvailableKeys() {
        List<class_304> availableBindings = ProfileHandler.getAvailableProfileKeys();
        List<class_2561> finalBindings = new ArrayList<>();
        availableBindings.forEach(binding -> {
            if (binding != null) finalBindings.add(binding.method_16007());
        });
        finalBindings.add(class_2561.method_43471("config.profiles.button.text.inventive_inventory.not_bound"));
        return finalBindings;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.method_25396().forEach(widgetEntry -> widgetEntry.method_25396().forEach(element -> {
            if (element instanceof ConfigProfileWidget widget) widget.horizontal.method_48206(clickableWidget -> clickableWidget.method_25365(false));
        }));
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    protected void onClose() {
        this.method_25396().forEach(widgetEntry -> widgetEntry.method_25396().forEach(element -> {
            if (element instanceof ConfigProfileWidget widget) widget.updateProfile();
        }));
    }
}
