package net.inventive_mods.inventive_inventory.config.screens.widgets;

import net.inventive_mods.inventive_inventory.util.widgets.WidgetHelper;
import net.minecraft.class_1144;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_7842;
import net.minecraft.class_8667;
import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.inventive_mods.inventive_inventory.config.screens.tabs.ConfigProfilesTab;
import net.inventive_mods.inventive_inventory.features.profiles.Profile;
import net.inventive_mods.inventive_inventory.features.profiles.ProfileHandler;
import net.inventive_mods.inventive_inventory.features.profiles.SavedSlot;
import net.inventive_mods.inventive_inventory.keys.KeyRegistry;
import net.inventive_mods.inventive_inventory.util.Drawer;
import net.inventive_mods.inventive_inventory.util.widgets.CustomClickableWidget;

import java.util.List;

public class ConfigProfileWidget extends CustomClickableWidget {
    public final class_8667 horizontal = class_8667.method_52742().method_52735(10);
    private final Profile profile;
    private final class_342 name;
    private final class_4185 key;
    private final ConfigProfilesTab parent;

    public ConfigProfileWidget(int width, int height, int index, Profile profile, ConfigProfilesTab parent) {
        super(width, height);
        this.profile = profile;
        this.parent = parent;
        class_310 client = InventiveInventory.getClient();

        this.name = new class_342(client.field_1772, 80, height, class_2561.method_43473());
        this.name.method_1852(this.profile.getName());
        this.name.method_47404(class_2561.method_43471("config.profiles.text_field.inventive_inventory.placeholder"));

        class_304 profileKey = KeyRegistry.getByTranslationKey(this.profile.getKey());
        class_2561 initially = profileKey != null ? profileKey.method_16007() : class_2561.method_43471("config.profiles.button.text.inventive_inventory.not_bound");

        this.key = class_4185.method_46430(initially, this.toggle()).method_46431();
        this.key.method_25358(60);

        Hotbar hotbar = new Hotbar(profile.getSavedSlots());

        this.horizontal.method_52736(new class_7842(client.field_1772.method_1727(index + "."), this.field_22759, class_2561.method_30163(index + "."), client.field_1772));
        this.horizontal.method_52736(this.name);
        this.horizontal.method_52736(this.key);
        this.horizontal.method_52736(hotbar);
        this.horizontal.method_48222();
        this.field_22758 = this.horizontal.method_25368();
    }

    @Override
    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        this.horizontal.method_48229(this.method_46426(), this.method_46427());
        this.horizontal.method_48206(clickableWidget -> clickableWidget.method_25394(context, mouseX, mouseY, delta));
    }

    public void updateProfile() {
        String name = this.name.method_1882();
        class_304 keyBinding = KeyRegistry.getByBoundKey(this.key.method_25369().getString());
        String key = keyBinding != null ? keyBinding.method_1431() : "";
        if (!name.equals(this.profile.getName()) || !key.equals(this.profile.getKey())) {
            this.profile.setName(name);
            this.profile.setKey(key);
            ProfileHandler.update(this.profile);
        }
    }

    private class_4185.class_4241 toggle() {
        return button -> {
            class_2561 message = button.method_25369();
            class_2561 newMessage = this.parent.availableKeys.get(0);
            if (message.getString().equals(newMessage.getString())) {
                this.parent.availableKeys.remove(newMessage);
                this.parent.availableKeys.add(newMessage);
                newMessage = this.parent.availableKeys.get(0);
            }
            if (!message.getString().equals("Not Bound")) {
                this.parent.availableKeys.add(message);
            }
            if (!newMessage.getString().equals("Not Bound")) {
                this.parent.availableKeys.remove(newMessage);
            }
            button.method_25355(newMessage);
            class_304 keyBinding = KeyRegistry.getByBoundKey(button.method_25369().getString());
            if (keyBinding != null) this.profile.setKey(keyBinding.method_1431());
        };
    }

    @Override
    public void method_25348(double mouseX, double mouseY) {
        this.horizontal.method_48206(widget -> {
            if (mouseX >= widget.method_46426() && mouseX <= WidgetHelper.getRight(widget) && mouseY >= widget.method_46427() && mouseY <= WidgetHelper.getBottom(widget)) {
                widget.method_25365(true);
                widget.method_25348(mouseX, mouseY);
                if (widget instanceof class_4185 button) {
                    button.method_25354(InventiveInventory.getClient().method_1483());
                }
            }
        });
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        this.horizontal.method_48206(widget -> widget.method_25404(keyCode, scanCode, modifiers));
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25400(char chr, int modifiers) {
        this.horizontal.method_48206(widget -> widget.method_25400(chr, modifiers));
        return super.method_25400(chr, modifiers);
    }

    @Override
    public void method_25354(class_1144 soundManager) {}

    private static class Hotbar extends CustomClickableWidget {

        private final List<SavedSlot> savedSlots;

        public Hotbar(List<SavedSlot> savedSlots) {
            super(205, 20);
            this.savedSlots = savedSlots;
        }
        @Override
        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            Drawer.drawProfileHotbar(context, this.method_46426(), this.method_46427());

            int slotX = this.method_46426() + 27;
            int slotY = this.method_46427() + 2;
            for (SavedSlot savedSlot : this.savedSlots) {
                if (savedSlot.slot() == class_1723.field_30812) {
                    context.method_51427(savedSlot.stack(), this.method_46426() + 2, slotY);
                    boolean inX = this.method_46426() + 2 < mouseX && mouseX < this.method_46426() + 2 + 16;
                    boolean inY = slotY < mouseY && mouseY < slotY + 16;
                    boolean isMouseOverItem = inX && inY;
                    if (isMouseOverItem) context.method_51446(InventiveInventory.getClient().field_1772, savedSlot.stack(), mouseX, mouseY);
                }
                for (int i = 0; i < 9; i++) {
                    if (savedSlot.slot() - class_1661.field_30638 == i) {
                        context.method_51427(savedSlot.stack(), slotX, slotY);
                        boolean inX = slotX < mouseX && mouseX < slotX + 16;
                        boolean inY = slotY < mouseY && mouseY < slotY + 16;
                        boolean isMouseOverItem = inX && inY;
                        if (isMouseOverItem) context.method_51446(InventiveInventory.getClient().field_1772, savedSlot.stack(), mouseX, mouseY);
                        break;
                    }
                }
                slotX += 20;
            }
        }
    }
}
