package net.inventive_mods.inventive_inventory.util.slots;

import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import java.util.ArrayList;
import java.util.List;

public class PlayerSlots {
    public static SlotRange get() {
        class_1703 screenHandler = InventiveInventory.getScreenHandler();
        if (screenHandler == null) return new SlotRange(0, 0);
        List<class_1735> playerSlots = screenHandler.field_7761.stream()
                .filter(slot -> slot.field_7871 instanceof class_1661)
                .filter(slot -> !class_1661.method_7380(slot.method_34266()))
                .filter(slot -> !(screenHandler instanceof class_1723) || !class_1723.method_36211(slot.field_7874))
                .toList();

        if (playerSlots.stream().anyMatch(slot -> slot.getClass().equals(class_1735.class))) {
            playerSlots = playerSlots.stream().filter(slot -> slot.getClass().equals(class_1735.class)).toList();
        }
        if (playerSlots.isEmpty()) return new SlotRange(0, 0);
        int start = playerSlots.getFirst().field_7874;
        int stop = playerSlots.getLast().field_7874;
        return new SlotRange(start, stop);
    }

    public static SlotRange get(SlotTypes... types) {
        SlotRange slotRange = SlotRange.of(new ArrayList<>());
        for (SlotTypes type : types) {
            if (type != SlotTypes.LOCKED_SLOT) slotRange.append(type);
            else throw new IllegalArgumentException("This SlotType is not valid in this function");
        }
        return slotRange;
    }
}
