package net.inventive_mods.inventive_inventory.config.options;

import net.inventive_mods.inventive_inventory.util.widgets.CenteredTextWidget;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.inventive_mods.inventive_inventory.config.ConfigManager;
import net.inventive_mods.inventive_inventory.config.enums.accessors.Stylable;
import net.inventive_mods.inventive_inventory.config.enums.accessors.Translatable;
import net.inventive_mods.inventive_inventory.config.screens.widgets.ConfigTextWidget;
import org.jetbrains.annotations.Nullable;


public abstract class ConfigOption<T> {
    protected static final String SIMPLE_TRANSLATION_KEY = "config.universal.button.text." + InventiveInventory.MOD_ID + ".universal.simple.";
    protected final String tab;
    private final String key;
    private final T defaultValue;
    private T value;

    public static class_2561 getValueAsText(Object value) {
        if (value instanceof Boolean) return (Boolean) value ? class_2561.method_43471(SIMPLE_TRANSLATION_KEY + "yes") : class_2561.method_43471(SIMPLE_TRANSLATION_KEY + "no");
        else if (value instanceof Enum<?>) {
            class_2561 text = class_2561.method_43473();
            if (value instanceof Translatable) text = ((Translatable) value).getButtonText();
            if (value instanceof Stylable) text = text.method_27661().method_10862(((Stylable) value).getStyle());
            return text;
        } else return class_2561.method_43473();
    }

    public ConfigOption(String tab, String key, T defaultValue) {
        this.tab = tab;
        this.key = key;
        this.value = this.defaultValue = defaultValue;
    }

    public boolean is(T value) {
        return this.value == value;
    }

    public String getTranslationKey() {
        return "config." + this.tab +  ".label." + InventiveInventory.MOD_ID + "." + this.key;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
        ConfigManager.save();
    }

    public void reset() {
        this.setValue(this.defaultValue);
    }

    public CenteredTextWidget createLabel() {
        return new ConfigTextWidget(class_2561.method_43471(this.getTranslationKey()), InventiveInventory.getClient().field_1772);
    }

    public abstract void setValue(@Nullable String value);

    public abstract class_339 asWidget();
}
