package net.inventive_mods.inventive_inventory.features.profiles.gui;

import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.inventive_mods.inventive_inventory.features.profiles.Profile;
import net.inventive_mods.inventive_inventory.features.profiles.ProfileHandler;
import net.inventive_mods.inventive_inventory.features.profiles.gui.widgets.Section;
import net.inventive_mods.inventive_inventory.keys.KeyRegistry;
import net.inventive_mods.inventive_inventory.util.mouse.MouseLocation;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_465;
import java.util.ArrayList;
import java.util.List;

public class ProfilesScreen extends class_465<class_1703> {
    public static final int RADIUS = 60;
    public static final int COLOR = 0x7F000000;
    public static final int HOVER_COLOR = 0x3FFFFFFF;
    public static final int DELETE_COLOR = 0x7FE4080A;
    public static final int OVERWRITE_COLOR = 0x7FFFDE59;
    private static final List<Section> sections = new ArrayList<>();
    public static boolean DELETE_KEY_PRESSED;
    public static boolean OVERWRITE_KEY_PRESSED;
    private int mouseX;
    private int mouseY;

    public ProfilesScreen() {
        super(InventiveInventory.getScreenHandler(), InventiveInventory.getPlayer().method_31548(), class_2561.method_43470("Profile Screen"));
        if (this.field_22787 != null) this.field_22787.method_18502(null);
        sections.clear();
        for (Profile profile : ProfileHandler.getProfiles()) {
            if (sections.size() <= ProfileHandler.MAX_PROFILES) sections.add(new Section(sections.size(), profile));
        }
        if (sections.size() < ProfileHandler.MAX_PROFILES) sections.add(new Section(sections.size(), null));
        DELETE_KEY_PRESSED = false;
        OVERWRITE_KEY_PRESSED = false;
    }

    public static List<Section> getSections() {
        return sections;
    }

    @Override
    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
    }

    @Override
    public void method_25420(class_332 context, int mouseX, int mouseY, float deltaTicks) {
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;

        for (Section section : sections) {
            section.drawBackground(context, section.isHovered(mouseX, mouseY));
        }

        for (Section section : sections) {
            section.drawIcon(context);
            section.drawTooltips(context, mouseX, mouseY);
        }
    }

    @Override
    public boolean method_25404(class_11908 keyInput) {
        if (class_3675.field_31949 == keyInput.comp_4795()) {
            DELETE_KEY_PRESSED = true;
            return true;
        } else if (class_3675.field_31950 == keyInput.comp_4795()) {
            OVERWRITE_KEY_PRESSED = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean method_16803(class_11908 keyInput) {
        if (KeyRegistry.openProfilesScreenKey.method_1417(keyInput)) {
            return inputAction();
        }
        if (class_3675.field_31950 == keyInput.comp_4795()) {
            OVERWRITE_KEY_PRESSED = false;
            return true;
        }
        if (class_3675.field_31949 == keyInput.comp_4795()) {
            DELETE_KEY_PRESSED = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25406(class_11909 click) {
        if (KeyRegistry.openProfilesScreenKey.method_1433(click)) {
            return inputAction();
        }
        return false;
    }

    private boolean inputAction() {
        int section = MouseLocation.getHoveredProfileSection(this.mouseX, this.mouseY);
        if (section != -1) {
            Profile profile = sections.get(section).getProfile();
            if (profile == null) {
                if (DELETE_KEY_PRESSED) {
                    if (field_22787 != null) field_22787.method_63588(() -> field_22787.method_1507(new ProfilesNamingScreen()));
                } else {
                    ProfileHandler.create("", ProfileHandler.getAvailableProfileKey());
                }
            } else if (DELETE_KEY_PRESSED) {
                ProfileHandler.delete(profile);
            } else if (OVERWRITE_KEY_PRESSED) {
                ProfileHandler.overwrite(profile);
            } else {
                ProfileHandler.load(profile);
            }
        }
        this.method_25419();
        return true;
    }
}
