package net.inventive_mods.inventive_inventory.util;

import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.inventive_mods.inventive_inventory.config.enums.item_counter.ItemCounterCountingMode;
import net.inventive_mods.inventive_inventory.config.ConfigManager;
import net.inventive_mods.inventive_inventory.config.enums.locked_slots.Style;
import net.inventive_mods.inventive_inventory.config.options.ConfigOption;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class Drawer {

    public static void drawSlotBackground(class_332 context, int x, int y, int color, boolean outlined) {
        if (outlined) {
            int width = 15, height = 15;
            context.method_25294(x, y, x + width, y + 1, color);
            context.method_25294(x, y + height, x + width + 1, y + height + 1, color);
            context.method_25294(x, y, x + 1, y + height, color);
            context.method_25294(x + width, y, x + width + 1, y + height, color);
        } else context.method_25294(x, y, x + 16, y + 16, color);
    }

    public static void drawTexture(class_332 context, class_2960 texture, int x, int y, int size) {
        context.method_25290(class_10799.field_56883, texture, x, y, 0, 0, size, size, size, size);
    }

    public static void drawProfileHotbar(class_332 context, int x, int y) {
        context.method_25290(class_10799.field_56883, Textures.HOTBAR, x, y, 0, 0, 205, 20, 205, 20);
    }

    public static void drawLockedSlot(class_332 context, class_2960 texture, ConfigOption<Integer> option, int x, int y) {
        context.method_25290(class_10799.field_56883, texture, x, y, 0, 0, 20, 20, 20, 20);
        Drawer.drawSlotBackground(context, x + 2, y + 2, option.getValue(), ConfigManager.LOCKED_SLOT_STYLE.is(Style.OUTLINED));
        if (ConfigManager.SHOW_LOCK.is(true)) Drawer.drawTexture(context, Textures.LOCK, x + 14, y, 8);
    }

    public static void drawItemCounter(class_332 context, int x, int y, int count, class_1799 stack) {
        String text = ConfigManager.ITEM_COUNTER_COUNTING_MODE.is(ItemCounterCountingMode.ITEMS) ? Integer.toString(count) : "[" + (count / stack.method_7914()) + "]";
        context.method_51448().pushMatrix();
        context.method_51448().scale(0.5f, 0.5f);
        if ((ConfigManager.ITEM_COUNTER_COUNTING_MODE.is(ItemCounterCountingMode.ITEMS) && count != 0) || count / stack.method_7914() != 0)
            context.method_51433(InventiveInventory.getClient().field_1772, text, x * 2, y * 2, ConfigManager.ITEM_COUNTER_COLOR.getValue(), false);
        context.method_51448().popMatrix();
    }
}
