/*
 * Decompiled with CFR 0.152.
 */
package net.inventive_mods.inventive_inventory.features.locked_slots;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.inventive_mods.inventive_inventory.config.ConfigManager;
import net.inventive_mods.inventive_inventory.context.ContextManager;
import net.inventive_mods.inventive_inventory.context.Contexts;
import net.inventive_mods.inventive_inventory.features.locked_slots.LockedSlots;
import net.inventive_mods.inventive_inventory.util.FileHandler;
import net.inventive_mods.inventive_inventory.util.InteractionHandler;
import net.inventive_mods.inventive_inventory.util.ScreenCheck;
import net.inventive_mods.inventive_inventory.util.slots.PlayerSlots;
import net.inventive_mods.inventive_inventory.util.slots.SlotTypes;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class LockedSlotsHandler {
    private static final String LOCKED_SLOTS_FILE = "locked_slots.json";
    public static final Path LOCKED_SLOTS_PATH = ConfigManager.CONFIG_PATH.resolve("locked_slots.json");
    private static final List<class_1799> savedInventory = new ArrayList<class_1799>();
    private static final List<class_1799> savedHandlerInventory = new ArrayList<class_1799>();
    public static boolean shouldAdd;
    public static boolean shouldInit;
    public static boolean schedulerStarted;
    private static LockedSlots lockedSlots;
    public static final int HOVER_COLOR = 0x66FF0000;
    public static final int LOCKED_HOVER_COLOR = -7667712;

    public static void toggle(int slot) {
        ContextManager.setContext(Contexts.LOCKED_SLOTS);
        if (PlayerSlots.get().append(SlotTypes.HOTBAR).contains(slot)) {
            lockedSlots = LockedSlotsHandler.getLockedSlots();
            if (lockedSlots.contains(slot)) {
                lockedSlots.remove((Object)slot);
                shouldAdd = false;
            } else {
                lockedSlots.add(slot);
                shouldAdd = true;
            }
            LockedSlotsHandler.save();
        }
    }

    public static void dragToggle(int slot) {
        if (PlayerSlots.get().append(SlotTypes.HOTBAR).contains(slot)) {
            lockedSlots = LockedSlotsHandler.getLockedSlots();
            if (shouldAdd) {
                if (!lockedSlots.contains(slot)) {
                    lockedSlots.add(slot);
                }
            } else {
                lockedSlots.remove((Object)slot);
            }
            LockedSlotsHandler.save();
        }
    }

    public static void init() {
        LockedSlotsHandler.reset();
        shouldInit = false;
        JsonObject jsonFile = FileHandler.get(LOCKED_SLOTS_PATH);
        JsonArray lockedSlotsJson = new JsonArray();
        if (jsonFile.isJsonObject() && jsonFile.getAsJsonObject().has(InventiveInventory.getWorldName())) {
            lockedSlotsJson = jsonFile.getAsJsonObject().getAsJsonArray(InventiveInventory.getWorldName());
        }
        for (JsonElement slot : lockedSlotsJson.getAsJsonArray()) {
            lockedSlots.add(slot.getAsInt());
        }
    }

    public static void reset() {
        lockedSlots.clear();
        savedInventory.clear();
        savedHandlerInventory.clear();
    }

    public static LockedSlots getLockedSlots() {
        return lockedSlots.adjust();
    }

    public static void adjustInventory() {
        ArrayList<class_1799> currentInventory = new ArrayList<class_1799>((Collection<class_1799>)InventiveInventory.getPlayer().method_31548().method_67533());
        if (savedInventory.isEmpty()) {
            return;
        }
        boolean itemTaken = LockedSlotsHandler.isItemTaken(currentInventory);
        boolean itemMoved = LockedSlotsHandler.isItemMoved(itemTaken);
        ContextManager.setContext(Contexts.LOCKED_SLOTS);
        if (ConfigManager.PICKUP_INTO_LOCKED_SLOTS.is(false) && itemTaken && !itemMoved) {
            LockedSlotsHandler.rearrange(currentInventory, InteractionHandler::dropItem);
        } else if (ConfigManager.QUICK_MOVE_INTO_LOCKED_SLOTS.is(false) && itemMoved) {
            LockedSlotsHandler.rearrange(currentInventory, (slot, times) -> InteractionHandler.quickMove(slot));
        }
        ContextManager.setContext(Contexts.INIT);
    }

    public static void setSavedInventory() {
        savedInventory.clear();
        for (class_1799 stack : InventiveInventory.getPlayer().method_31548().method_67533()) {
            savedInventory.add(stack.method_7972());
        }
        savedInventory.add(InteractionHandler.getCursorStack().method_7972());
    }

    public static void setSavedHandlerInventory() {
        savedHandlerInventory.clear();
        if (!ScreenCheck.isNone()) {
            for (int i = 0; i < InventiveInventory.getScreenHandler().field_7761.size(); ++i) {
                savedHandlerInventory.add(InteractionHandler.getStackFromSlot(i).method_7972());
            }
        }
    }

    private static Map<class_1792, Integer> getItemCountMap(List<class_1799> inventory) {
        return inventory.stream().collect(Collectors.toMap(class_1799::method_7909, class_1799::method_7947, Integer::sum));
    }

    private static boolean isItemTaken(List<class_1799> currentInventory) {
        Map<class_1792, Integer> currentCountMap = LockedSlotsHandler.getItemCountMap(currentInventory);
        Map<class_1792, Integer> savedCountMap = LockedSlotsHandler.getItemCountMap(savedInventory);
        return currentCountMap.entrySet().stream().anyMatch(entry -> (Integer)entry.getValue() > savedCountMap.getOrDefault(entry.getKey(), 0));
    }

    private static boolean isItemMoved(boolean tookItem) {
        ArrayList<class_1799> currentHandlerInventory = new ArrayList<class_1799>();
        for (int i = 0; i < InventiveInventory.getScreenHandler().field_7761.size(); ++i) {
            currentHandlerInventory.add(InteractionHandler.getStackFromSlot(i).method_7972());
        }
        Map<class_1792, Integer> currentCountMap = LockedSlotsHandler.getItemCountMap(currentHandlerInventory);
        Map<class_1792, Integer> savedCountMap = LockedSlotsHandler.getItemCountMap(savedHandlerInventory);
        return tookItem && currentCountMap.entrySet().stream().allMatch(entry -> ((Integer)entry.getValue()).equals(savedCountMap.getOrDefault(entry.getKey(), 0)));
    }

    private static void rearrange(List<class_1799> currentInventory, BiConsumer<Integer, Integer> func) {
        if (savedInventory.isEmpty()) {
            return;
        }
        LockedSlots lockedSlots = LockedSlotsHandler.getLockedSlots();
        int i = 0;
        Iterator iterator = PlayerSlots.get(SlotTypes.HOTBAR).append(SlotTypes.INVENTORY).iterator();
        while (iterator.hasNext()) {
            int invSlot = (Integer)iterator.next();
            class_1799 currentStack = currentInventory.get(i);
            class_1799 savedStack = savedInventory.get(i);
            ++i;
            if (!lockedSlots.contains(invSlot) || class_1799.method_7973((class_1799)currentStack, (class_1799)savedStack)) continue;
            List<Integer> suitableSlots = PlayerSlots.get(SlotTypes.HOTBAR).append(SlotTypes.INVENTORY).exclude(SlotTypes.LOCKED_SLOT).stream().filter(slot -> {
                class_1799 stack = InteractionHandler.getStackFromSlot(slot);
                return stack.method_7960() || class_1799.method_7984((class_1799)stack, (class_1799)currentStack) && stack.method_7947() < stack.method_7914();
            }).sorted(Comparator.comparing(slot -> InteractionHandler.getStackFromSlot(slot).method_7947(), Comparator.reverseOrder())).toList();
            if (!suitableSlots.isEmpty()) {
                InteractionHandler.leftClickStack(invSlot);
                for (int slot2 : suitableSlots) {
                    class_1799 stack = InteractionHandler.getStackFromSlot(slot2);
                    while (InteractionHandler.getCursorStack().method_7947() > savedStack.method_7947() && stack.method_7947() < stack.method_7914()) {
                        InteractionHandler.rightClickStack(slot2);
                    }
                }
                InteractionHandler.leftClickStack(invSlot);
            }
            if (InteractionHandler.getStackFromSlot(invSlot).method_7947() <= savedStack.method_7947()) continue;
            func.accept(invSlot, InteractionHandler.getStackFromSlot(invSlot).method_7947() - savedStack.method_7947());
        }
    }

    private static void save() {
        lockedSlots = lockedSlots.unadjust();
        JsonArray lockedSlotsJson = new JsonArray();
        Iterator iterator = lockedSlots.iterator();
        while (iterator.hasNext()) {
            int lockedSlot = (Integer)iterator.next();
            lockedSlotsJson.add((Number)lockedSlot);
        }
        JsonObject jsonObject = FileHandler.get(LOCKED_SLOTS_PATH).isJsonObject() ? FileHandler.get(LOCKED_SLOTS_PATH).getAsJsonObject() : new JsonObject();
        jsonObject.remove(InventiveInventory.getWorldName());
        jsonObject.add(InventiveInventory.getWorldName(), (JsonElement)lockedSlotsJson);
        FileHandler.write(LOCKED_SLOTS_PATH, (JsonElement)jsonObject);
    }

    public static void startScheduler() {
        final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        Runnable task = new Runnable(){
            private int iteration = 0;

            @Override
            public void run() {
                if (this.iteration > 10) {
                    shouldInit = true;
                    scheduler.shutdown();
                }
                ++this.iteration;
            }
        };
        scheduler.scheduleAtFixedRate(task, 0L, 50L, TimeUnit.MILLISECONDS);
        schedulerStarted = true;
    }

    static {
        lockedSlots = LockedSlots.empty();
    }
}

