/*
 * Decompiled with CFR 0.152.
 */
package net.inventive_mods.inventive_inventory.features.profiles.gui.widgets;

import java.util.List;
import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.inventive_mods.inventive_inventory.features.profiles.Profile;
import net.inventive_mods.inventive_inventory.features.profiles.gui.ProfilesScreen;
import net.inventive_mods.inventive_inventory.features.profiles.gui.render_state.ProfileScreenBackgroundGuiElementRenderState;
import net.inventive_mods.inventive_inventory.util.Textures;
import net.inventive_mods.inventive_inventory.util.mouse.MouseLocation;
import net.inventive_mods.inventive_inventory.util.tooltips.TooltipBuilder;
import net.inventive_mods.inventive_inventory.util.tooltips.TooltipType;
import net.minecraft.class_10799;
import net.minecraft.class_11244;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class Section {
    private final int ID;
    private final Profile profile;
    private int iconX;
    private int iconY;

    public Section(int ID, Profile profile) {
        this.ID = ID;
        this.profile = profile;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return MouseLocation.getHoveredProfileSection(mouseX, mouseY) == this.ID;
    }

    public void drawBackground(class_332 context, boolean hovered) {
        int color;
        int startAngle = 360 / ProfilesScreen.getSections().size() * this.ID;
        int limit = 360 / ProfilesScreen.getSections().size() + startAngle;
        int centerX = InventiveInventory.getScreen().field_22789 / 2;
        int centerY = InventiveInventory.getScreen().field_22790 / 2;
        int innerRadius = 30;
        int n = color = hovered ? 0x3FFFFFFF : 0x7F000000;
        if (this.profile != null && hovered) {
            if (ProfilesScreen.DELETE_KEY_PRESSED) {
                color = 2145650698;
            } else if (ProfilesScreen.OVERWRITE_KEY_PRESSED) {
                color = 2147475033;
            }
        }
        while (startAngle < limit) {
            double angle = (double)startAngle * Math.PI / 180.0;
            double nextAngle = (double)(startAngle + 1) * Math.PI / 180.0;
            float posX = (float)centerX + (float)Math.sin(angle) * 60.0f;
            float posY = (float)centerY - (float)Math.cos(angle) * 60.0f;
            float posInnerX = (float)centerX + (float)Math.sin(angle) * (float)innerRadius;
            float posInnerY = (float)centerY - (float)Math.cos(angle) * (float)innerRadius;
            float nextPosX = (float)centerX + (float)Math.sin(nextAngle) * 60.0f;
            float nextPosY = (float)centerY - (float)Math.cos(nextAngle) * 60.0f;
            float nextPosInnerX = (float)centerX + (float)Math.sin(nextAngle) * (float)innerRadius;
            float nextPosInnerY = (float)centerY - (float)Math.cos(nextAngle) * (float)innerRadius;
            context.field_59826.method_70919((class_11244)new ProfileScreenBackgroundGuiElementRenderState(context, posX, posY, posInnerX, posInnerY, nextPosInnerX, nextPosInnerY, nextPosX, nextPosY, color));
            ++startAngle;
        }
    }

    public void drawIcon(class_332 context) {
        int startAngle = 360 / ProfilesScreen.getSections().size() * this.ID;
        int limit = 360 / ProfilesScreen.getSections().size() + startAngle;
        int centerX = InventiveInventory.getScreen().field_22789 / 2;
        int centerY = InventiveInventory.getScreen().field_22790 / 2;
        int innerRadius = 30;
        int middleAngle = startAngle + (limit - startAngle) / 2;
        double middleRadian = (double)middleAngle * Math.PI / 180.0;
        int middleX = (int)((double)centerX + Math.sin(middleRadian) * (60.0 - (double)(60 - innerRadius) / 2.0));
        int middleY = (int)((double)centerY - Math.cos(middleRadian) * (60.0 - (double)(60 - innerRadius) / 2.0));
        this.iconX = middleX - 8;
        this.iconY = middleY - 8;
        if (this.profile == null) {
            context.method_25290(class_10799.field_56883, Textures.PLUS, this.iconX, this.iconY, 0.0f, 0.0f, 16, 16, 16, 16);
        } else if (this.profile.getDisplayStack().method_7960()) {
            context.method_25290(class_10799.field_56883, Textures.TOOLS, this.iconX, this.iconY, 0.0f, 0.0f, 16, 16, 16, 16);
        } else {
            context.method_51427(this.profile.getDisplayStack(), this.iconX, this.iconY);
        }
    }

    public void drawTooltips(class_332 context, int mouseX, int mouseY) {
        boolean isMouseOverIcon;
        boolean inX = this.iconX < mouseX && mouseX < this.iconX + 16;
        boolean inY = this.iconY < mouseY && mouseY < this.iconY + 16;
        boolean bl = isMouseOverIcon = inX && inY;
        if (isMouseOverIcon) {
            List<class_2561> textList = this.profile != null ? (!this.profile.getName().isEmpty() ? TooltipBuilder.of(TooltipType.NAME, this.profile) : (!this.profile.getDisplayStack().method_7960() ? TooltipBuilder.of(TooltipType.ITEM, this.profile) : TooltipBuilder.of(TooltipType.UNKNOWN, this.profile))) : TooltipBuilder.of(TooltipType.PLUS, null);
            context.method_51434(InventiveInventory.getClient().field_1772, textList, mouseX, mouseY);
        }
    }
}

