/*
 * Decompiled with CFR 0.152.
 */
package net.inventive_mods.inventive_inventory.util.widgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.inventive_mods.inventive_inventory.config.screens.ConfigScreen;
import net.inventive_mods.inventive_inventory.util.widgets.screen_tab.CustomElementListWidget;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import net.minecraft.class_8016;
import org.jetbrains.annotations.Nullable;

public abstract class CustomListWidget
extends CustomElementListWidget<WidgetEntry> {
    public CustomListWidget(class_310 client, int width, ConfigScreen screen) {
        super(client, width, screen.layout.getContentHeight(), screen.layout.method_48998(), 25);
    }

    @Override
    protected int getScrollbarPositionX() {
        return this.method_25368() / 2 + this.getRowWidth() / 2 + 5;
    }

    public void addAll(List<class_339> widgets) {
        for (int i = 0; i < widgets.size(); i += 2) {
            this.addWidgetEntry(widgets.get(i), i < widgets.size() - 1 ? widgets.get(i + 1) : null);
        }
    }

    public void addWidgetEntry(class_339 firstWidget, @Nullable class_339 secondWidget) {
        this.addEntry(WidgetEntry.create(firstWidget, secondWidget));
    }

    @Override
    public int getRowWidth() {
        if (this.method_25396().isEmpty()) {
            return this.field_22758;
        }
        AtomicInteger longest = new AtomicInteger();
        this.method_25396().forEach(entry -> longest.set(Math.max(longest.get(), entry.widgets.get(0).method_25368())));
        return longest.get();
    }

    @Override
    public int getRowLeft() {
        return (this.field_22758 - this.getRowWidth()) / 2;
    }

    public Optional<class_364> method_19355(double mouseX, double mouseY) {
        return super.method_19355(mouseX, mouseY);
    }

    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        return super.method_25400(chr, modifiers);
    }

    @Nullable
    public class_8016 method_48218() {
        return super.method_48218();
    }

    public void method_20086(@Nullable class_364 element) {
        super.method_20086(element);
    }

    public void method_48229(int x, int y) {
        super.method_48229(x, y);
    }

    @Environment(value=EnvType.CLIENT)
    protected static class WidgetEntry
    extends CustomElementListWidget.CustomEntry<WidgetEntry> {
        private final List<class_339> widgets;

        WidgetEntry(List<class_339> widgets) {
            this.widgets = ImmutableList.copyOf(widgets);
        }

        public static WidgetEntry create(class_339 firstWidget, @Nullable class_339 secondWidget) {
            return secondWidget == null ? new WidgetEntry((List<class_339>)ImmutableList.of((Object)firstWidget)) : new WidgetEntry((List<class_339>)ImmutableList.of((Object)firstWidget, (Object)secondWidget));
        }

        @Override
        public void render(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int i = 0;
            for (class_339 clickableWidget : this.widgets) {
                clickableWidget.method_48229(x + i, y);
                clickableWidget.method_25394(context, mouseX, mouseY, tickDelta);
                i += 160;
            }
        }

        public List<? extends class_364> method_25396() {
            return this.widgets;
        }

        @Override
        public List<? extends class_6379> selectableChildren() {
            return this.widgets;
        }
    }
}

