/*
 * Decompiled with CFR 0.152.
 */
package net.inventive_mods.inventive_inventory.features.profiles;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.inventive_mods.inventive_inventory.config.ConfigManager;
import net.inventive_mods.inventive_inventory.config.enums.Status;
import net.inventive_mods.inventive_inventory.features.profiles.Profile;
import net.inventive_mods.inventive_inventory.features.profiles.SavedSlot;
import net.inventive_mods.inventive_inventory.keys.KeyRegistry;
import net.inventive_mods.inventive_inventory.util.ComponentsHelper;
import net.inventive_mods.inventive_inventory.util.FileHandler;
import net.inventive_mods.inventive_inventory.util.InteractionHandler;
import net.inventive_mods.inventive_inventory.util.Notifier;
import net.inventive_mods.inventive_inventory.util.slots.PlayerSlots;
import net.inventive_mods.inventive_inventory.util.slots.SlotRange;
import net.inventive_mods.inventive_inventory.util.slots.SlotTypes;
import net.minecraft.class_124;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;

public class ProfileHandler {
    private static final String NOTIFICATION_TRANSLATION_KEY = "notification.profiles.inventive_inventory.";
    public static final int MAX_PROFILES = 5;
    private static final String PROFILES_FILE = "profiles.json";
    public static final Path PROFILES_PATH = ConfigManager.CONFIG_PATH.resolve("profiles.json");
    private static final List<Profile> profiles = new ArrayList<Profile>();

    public static void create(String name, String key) {
        if (InventiveInventory.getPlayer().method_7337() || ConfigManager.PROFILES_STATUS.is(Status.DISABLED)) {
            return;
        }
        Profile profile = new Profile(profiles.size(), name, key, ProfileHandler.createSavedSlots());
        if (profiles.size() < 5) {
            profiles.add(profile);
            ProfileHandler.save();
            Notifier.send(class_2561.method_43471((String)"notification.profiles.inventive_inventory.created").getString(), class_124.field_1060);
            return;
        }
        Notifier.error(class_2561.method_43471((String)"error.profiles.inventive_inventory.max_amount").getString());
    }

    public static void load(Profile profile) {
        if (InventiveInventory.getPlayer().method_7337() || ConfigManager.PROFILES_STATUS.is(Status.DISABLED)) {
            return;
        }
        SlotRange slotRange = PlayerSlots.get(SlotTypes.INVENTORY, SlotTypes.HOTBAR, SlotTypes.OFFHAND);
        slotRange = ConfigManager.PROFILES_IGNORE_LOCKED_SLOTS.is(true) ? slotRange.exclude(SlotTypes.LOCKED_SLOT) : slotRange;
        block0: for (SavedSlot savedSlot : profile.getSavedSlots()) {
            Iterator iterator = slotRange.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                class_1799 slotStack = InteractionHandler.getStackFromSlot(slot);
                if (!class_1799.method_7984((class_1799)slotStack, (class_1799)savedSlot.stack()) || !ComponentsHelper.areCustomNamesEqual(slotStack, savedSlot.stack()) || !ComponentsHelper.areEnchantmentsEqual(slotStack, savedSlot.stack()) || !ComponentsHelper.arePotionsEqual(slotStack, savedSlot.stack())) continue;
                InteractionHandler.swapStacks(slot, savedSlot.slot());
                continue block0;
            }
        }
        Notifier.send(class_2561.method_43471((String)"notification.profiles.inventive_inventory.loaded").getString(), class_124.field_1078);
    }

    public static void overwrite(Profile profile) {
        if (InventiveInventory.getPlayer().method_7337() || ConfigManager.PROFILES_STATUS.is(Status.DISABLED)) {
            return;
        }
        Profile newProfile = new Profile(profile.getId(), profile.getName(), profile.getKey(), ProfileHandler.createSavedSlots());
        profiles.set(profile.getId(), newProfile);
        ProfileHandler.save();
        Notifier.send(class_2561.method_43471((String)"notification.profiles.inventive_inventory.overwritten").getString(), class_124.field_1065);
    }

    public static void update(Profile profile) {
        if (InventiveInventory.getPlayer().method_7337() || ConfigManager.PROFILES_STATUS.is(Status.DISABLED)) {
            return;
        }
        Profile newProfile = new Profile(profile.getId(), profile.getName(), profile.getKey(), profile.getSavedSlots(), profile.getDisplayStack());
        profiles.set(profile.getId(), newProfile);
        ProfileHandler.save();
        Notifier.send(class_2561.method_43471((String)"notification.profiles.inventive_inventory.updated").getString(), class_124.field_1065);
    }

    public static void delete(Profile profile) {
        if (InventiveInventory.getPlayer().method_7337() || ConfigManager.PROFILES_STATUS.is(Status.DISABLED)) {
            return;
        }
        profiles.remove(profile.getId());
        for (int i = 0; i < profiles.size(); ++i) {
            profiles.get(i).setId(i);
        }
        ProfileHandler.save();
        Notifier.send(class_2561.method_43471((String)"notification.profiles.inventive_inventory.deleted").getString(), class_124.field_1061);
    }

    public static List<Profile> getProfiles() {
        return profiles;
    }

    public static boolean isNoProfile(String name) {
        for (Profile profile : profiles) {
            if (!profile.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public static String getAvailableProfileKey() {
        List<class_304> availableProfileKeys = ProfileHandler.getAvailableProfileKeys();
        if (availableProfileKeys.isEmpty()) {
            return "";
        }
        return availableProfileKeys.get(0).method_1431();
    }

    public static List<class_304> getAvailableProfileKeys() {
        ArrayList<class_304> availableProfileKeys = new ArrayList<class_304>(Arrays.asList(KeyRegistry.profileKeys));
        for (Profile profile : profiles) {
            for (class_304 profileKey : KeyRegistry.profileKeys) {
                if (!profileKey.method_1431().equals(profile.getKey())) continue;
                availableProfileKeys.remove(profileKey);
            }
        }
        return availableProfileKeys;
    }

    private static void save() {
        JsonObject jsonObject = FileHandler.get(PROFILES_PATH).isJsonObject() ? FileHandler.get(PROFILES_PATH).getAsJsonObject() : new JsonObject();
        jsonObject.remove(InventiveInventory.getWorldName());
        jsonObject.add(InventiveInventory.getWorldName(), (JsonElement)ProfileHandler.profilesToJson());
        FileHandler.write(PROFILES_PATH, (JsonElement)jsonObject);
    }

    private static List<SavedSlot> createSavedSlots() {
        class_1703 screenHandler = InventiveInventory.getScreenHandler();
        ArrayList<SavedSlot> savedSlots = new ArrayList<SavedSlot>();
        if (screenHandler == null) {
            return savedSlots;
        }
        Iterator iterator = PlayerSlots.get(SlotTypes.HOTBAR, SlotTypes.OFFHAND).iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            class_1799 stack = screenHandler.method_7611(slot).method_7677().method_7972();
            if (stack.method_7960()) continue;
            savedSlots.add(new SavedSlot(slot, stack));
        }
        return savedSlots;
    }

    public static void init() {
        profiles.clear();
        for (JsonElement jsonElement : ProfileHandler.getJsonProfiles()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            int id = jsonObject.getAsJsonPrimitive("id").getAsInt();
            String name = jsonObject.getAsJsonPrimitive("name").getAsString();
            String key = jsonObject.getAsJsonPrimitive("key").getAsString();
            JsonObject displayStack = jsonObject.getAsJsonObject("display_stack");
            JsonArray savedSlots = jsonObject.getAsJsonArray("saved_slots");
            profiles.add(new Profile(id, name, key, displayStack, savedSlots));
        }
    }

    private static JsonArray getJsonProfiles() {
        return FileHandler.get(PROFILES_PATH).isJsonObject() && FileHandler.get(PROFILES_PATH).getAsJsonObject().has(InventiveInventory.getWorldName()) ? FileHandler.get(PROFILES_PATH).getAsJsonObject().getAsJsonArray(InventiveInventory.getWorldName()) : new JsonArray();
    }

    private static JsonArray profilesToJson() {
        JsonArray jsonArray = new JsonArray();
        for (Profile profile : profiles) {
            jsonArray.add((JsonElement)profile.getAsJsonObject());
        }
        return jsonArray;
    }
}

