/*
 * Decompiled with CFR 0.152.
 */
package net.inventive_mods.inventive_inventory.features.sorting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.inventive_mods.inventive_inventory.config.ConfigManager;
import net.inventive_mods.inventive_inventory.util.InteractionHandler;
import net.inventive_mods.inventive_inventory.util.slots.SlotRange;
import net.minecraft.class_1799;

class SortingHelper {
    SortingHelper() {
    }

    public static void mergeItemStacks(SlotRange slotRange) {
        Integer emptySlot = null;
        SlotRange followingSlots = slotRange.copy();
        Iterator iterator = slotRange.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            followingSlots.remove((Object)slot);
            class_1799 stack = InteractionHandler.getStackFromSlot(slot);
            if (stack.method_7960() && emptySlot == null) {
                emptySlot = slot;
            }
            if (stack.method_7960() || stack.method_7947() >= stack.method_7914()) continue;
            Iterator iterator2 = followingSlots.iterator();
            while (iterator2.hasNext()) {
                int followingSlot = (Integer)iterator2.next();
                class_1799 followingStack = InteractionHandler.getStackFromSlot(followingSlot);
                if (class_1799.method_7984((class_1799)stack, (class_1799)followingStack) && followingStack.method_7947() < followingStack.method_7914()) {
                    InteractionHandler.swapStacks(followingSlot, slot);
                    continue;
                }
                if (!class_1799.method_7984((class_1799)stack, (class_1799)InteractionHandler.getCursorStack())) continue;
                InteractionHandler.leftClickStack(slot);
            }
        }
        if (InteractionHandler.isCursorFull()) {
            if (emptySlot != null) {
                InteractionHandler.leftClickStack(emptySlot);
            } else if (class_1799.method_7984((class_1799)InteractionHandler.getStackFromSlot((Integer)slotRange.get(slotRange.size() - 1)), (class_1799)InteractionHandler.getCursorStack())) {
                InteractionHandler.leftClickStack((Integer)slotRange.get(slotRange.size() - 1));
            }
        }
    }

    public static void sortItemStacks(SlotRange inventorySlots) {
        ArrayList<Integer> sortedSlots = new ArrayList<Integer>(SortingHelper.getSortedSlots(inventorySlots));
        for (int i = 0; i < sortedSlots.size(); ++i) {
            if (((Integer)sortedSlots.get(i)).equals(inventorySlots.get(i))) continue;
            if (class_1799.method_7984((class_1799)InteractionHandler.getStackFromSlot((Integer)sortedSlots.get(i)), (class_1799)InteractionHandler.getCursorStack())) {
                Iterator iterator = inventorySlots.iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    if (class_1799.method_7984((class_1799)InteractionHandler.getStackFromSlot(slot), (class_1799)InteractionHandler.getCursorStack()) || slot == (Integer)sortedSlots.get(i)) continue;
                    InteractionHandler.leftClickStack(slot);
                    InteractionHandler.swapStacks((Integer)sortedSlots.get(i), (Integer)inventorySlots.get(i));
                    InteractionHandler.leftClickStack(slot);
                    break;
                }
            } else {
                InteractionHandler.swapStacks((Integer)sortedSlots.get(i), (Integer)inventorySlots.get(i));
            }
            if (sortedSlots.contains(inventorySlots.get(i))) {
                sortedSlots.set(sortedSlots.indexOf(inventorySlots.get(i)), (Integer)sortedSlots.get(i));
            }
            sortedSlots.set(i, (Integer)inventorySlots.get(i));
        }
    }

    public static void adjustCursorStack(SlotRange slotRange, class_1799 targetStack) {
        if (targetStack.method_7947() > InteractionHandler.getCursorStack().method_7947()) {
            if (InteractionHandler.getCursorStack().method_7960()) {
                SortingHelper.handleEmptyCursorStack(slotRange, targetStack);
            } else {
                SortingHelper.handleFullCursorStack(slotRange, targetStack);
            }
            SortingHelper.rearrangeSlots(slotRange);
        }
    }

    private static void handleEmptyCursorStack(SlotRange slotRange, class_1799 targetStack) {
        List<Integer> sameStackSlots = SortingHelper.findSameStacks(slotRange, targetStack);
        Collections.reverse(sameStackSlots);
        InteractionHandler.leftClickStack(sameStackSlots.get(0));
        if (InteractionHandler.getCursorStack().method_7947() > targetStack.method_7947()) {
            while (InteractionHandler.getCursorStack().method_7947() > targetStack.method_7947()) {
                InteractionHandler.rightClickStack(sameStackSlots.get(0));
            }
        } else if (InteractionHandler.getCursorStack().method_7947() < targetStack.method_7947()) {
            InteractionHandler.leftClickStack(sameStackSlots.get(0));
            InteractionHandler.leftClickStack(sameStackSlots.get(1));
            while (InteractionHandler.getStackFromSlot(sameStackSlots.get(0)).method_7947() < targetStack.method_7947()) {
                InteractionHandler.rightClickStack(sameStackSlots.get(0));
            }
            InteractionHandler.leftClickStack(sameStackSlots.get(1));
            InteractionHandler.leftClickStack(sameStackSlots.get(0));
        }
    }

    private static void handleFullCursorStack(SlotRange slotRange, class_1799 targetStack) {
        List<Integer> sameStackSlots = SortingHelper.findSameStacks(slotRange, targetStack);
        Collections.reverse(sameStackSlots);
        slotRange.removeAll(sameStackSlots);
        if (slotRange.isEmpty()) {
            return;
        }
        InteractionHandler.leftClickStack((Integer)slotRange.get(0));
        InteractionHandler.leftClickStack(sameStackSlots.get(0));
        while (targetStack.method_7947() > InteractionHandler.getStackFromSlot((Integer)slotRange.get(0)).method_7947()) {
            InteractionHandler.rightClickStack((Integer)slotRange.get(0));
        }
        InteractionHandler.leftClickStack(sameStackSlots.get(0));
        InteractionHandler.leftClickStack((Integer)slotRange.get(0));
    }

    private static void rearrangeSlots(SlotRange slotRange) {
        SlotRange followingSlots = slotRange.copy();
        Iterator iterator = slotRange.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            followingSlots.remove((Object)slot);
            if (!InteractionHandler.getStackFromSlot(slot).method_7960()) continue;
            Iterator iterator2 = followingSlots.iterator();
            while (iterator2.hasNext()) {
                int followingSlot = (Integer)iterator2.next();
                InteractionHandler.swapStacks(followingSlot, slot);
                InteractionHandler.leftClickStack(followingSlot);
                slot = followingSlot;
            }
            return;
        }
    }

    private static List<Integer> getSortedSlots(SlotRange slotRange) {
        return slotRange.stream().filter(slot -> !InteractionHandler.getStackFromSlot(slot).method_7960()).sorted(ConfigManager.SORTING_MODE.getValue().getComparator()).toList();
    }

    private static List<Integer> findSameStacks(SlotRange slotRange, class_1799 targetStack) {
        return new ArrayList<Integer>(slotRange.stream().filter(slot -> class_1799.method_7984((class_1799)InteractionHandler.getStackFromSlot(slot), (class_1799)targetStack)).toList());
    }
}

