/*
 * Decompiled with CFR 0.152.
 */
package net.inventive_mods.inventive_inventory.util.widgets.screen_tab;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.inventive_mods.inventive_inventory.InventiveInventory;
import net.inventive_mods.inventive_inventory.util.widgets.WidgetHelper;
import net.inventive_mods.inventive_inventory.util.widgets.screen_tab.CustomContainerWidget;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8028;
import org.jetbrains.annotations.Nullable;

public abstract class CustomEntryListWidget<E extends CustomEntry<E>>
extends CustomContainerWidget {
    protected final class_310 client;
    protected final int itemHeight;
    private final Entries children = new Entries();
    private double scrollAmount;
    protected int headerHeight;
    private boolean scrolling;
    @Nullable
    private E selected;
    @Nullable
    private E hoveredEntry;

    public CustomEntryListWidget(class_310 client, int width, int height, int y, int itemHeight) {
        super(0, y, width, height, class_5244.field_39003);
        this.client = client;
        this.itemHeight = itemHeight;
    }

    public int getRowWidth() {
        return 220;
    }

    @Nullable
    public E getSelectedOrNull() {
        return this.selected;
    }

    public void setSelected(@Nullable E entry) {
        this.selected = entry;
    }

    @Nullable
    public E getFocused() {
        return (E)((CustomEntry)super.method_25399());
    }

    public final List<E> method_25396() {
        return this.children;
    }

    protected E getEntry(int index) {
        return (E)((CustomEntry)this.method_25396().get(index));
    }

    protected void addEntry(E entry) {
        this.children.add(entry);
    }

    protected int getEntryCount() {
        return this.method_25396().size();
    }

    protected boolean isSelectedEntry(int index) {
        return Objects.equals(this.getSelectedOrNull(), this.method_25396().get(index));
    }

    @Nullable
    protected final E getEntryAtPosition(double x, double y) {
        int i = this.getRowWidth() / 2;
        int j = this.method_46426() + this.field_22758 / 2;
        int k = j - i;
        int l = j + i;
        int m = class_3532.method_15357((double)(y - (double)this.method_46427())) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int n = m / this.itemHeight;
        return (E)(x < (double)this.getScrollbarPositionX() && x >= (double)k && x <= (double)l && n >= 0 && m >= 0 && n < this.getEntryCount() ? (CustomEntry)this.method_25396().get(n) : null);
    }

    protected int getMaxPosition() {
        return this.getEntryCount() * this.itemHeight + this.headerHeight;
    }

    protected void renderHeader(class_332 context) {
        context.method_51422(0.3f, 0.3f, 0.3f, 1.0f);
        context.method_25297(class_437.field_44669, 0, this.field_22758, 0, this.method_46427(), -1, this.field_22758, this.method_46427(), (float)WidgetHelper.getRight(this), (float)WidgetHelper.getBottom(this), 32, 32);
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void renderDecorations(class_332 context) {
        context.method_51422(0.3f, 0.3f, 0.3f, 1.0f);
        context.method_25297(class_437.field_44669, 0, this.field_22758, WidgetHelper.getBottom(this), InventiveInventory.getScreen().field_22790, -1, this.field_22758, InventiveInventory.getScreen().field_22790 - WidgetHelper.getBottom(this), (float)WidgetHelper.getRight(this), (float)WidgetHelper.getBottom(this), 32, 32);
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        this.hoveredEntry = this.method_25405(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        context.method_51422(0.125f, 0.125f, 0.125f, 1.0f);
        context.method_25290(class_437.field_44669, this.method_46426(), this.method_46427(), (float)WidgetHelper.getRight(this), (float)(WidgetHelper.getBottom(this) + (int)this.getScrollAmount()), this.field_22758, this.field_22759, 32, 32);
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        this.renderHeader(context);
        this.enableScissor(context);
        this.renderList(context, mouseX, mouseY, delta);
        context.method_44380();
        context.method_51740(class_1921.method_51785(), this.method_46426(), this.method_46427(), WidgetHelper.getRight(this), this.method_46427() + 4, -16777216, 0, 0);
        context.method_51740(class_1921.method_51785(), this.method_46426(), WidgetHelper.getBottom(this) - 4, WidgetHelper.getRight(this), WidgetHelper.getBottom(this), 0, -16777216, 0);
        int m = this.getMaxScroll();
        if (m > 0) {
            int n = (int)((float)((WidgetHelper.getBottom(this) - this.method_46427()) * (WidgetHelper.getBottom(this) - this.method_46427())) / (float)this.getMaxPosition());
            n = class_3532.method_15340((int)n, (int)32, (int)(WidgetHelper.getBottom(this) - this.method_46427() - 8));
            int o = (int)this.getScrollAmount() * (WidgetHelper.getBottom(this) - this.method_46427() - n) / m + this.method_46427();
            if (o < this.method_46427()) {
                o = this.method_46427();
            }
            int i = this.getScrollbarPositionX();
            int j = i + 6;
            context.method_25294(i, this.method_46427(), j, WidgetHelper.getBottom(this), -16777216);
            context.method_25294(i, o, j, o + n, -8355712);
            context.method_25294(i, o, j - 1, o + n - 1, -4144960);
        }
        this.renderDecorations(context);
        RenderSystem.disableBlend();
    }

    protected void enableScissor(class_332 context) {
        context.method_44379(this.method_46426(), this.method_46427(), WidgetHelper.getRight(this), WidgetHelper.getBottom(this));
    }

    protected void ensureVisible(E entry) {
        int k;
        int i = this.getRowTop(this.method_25396().indexOf(entry));
        int j = i - this.method_46427() - 4 - this.itemHeight;
        if (j < 0) {
            this.scroll(j);
        }
        if ((k = WidgetHelper.getBottom(this) - i - this.itemHeight - this.itemHeight) < 0) {
            this.scroll(-k);
        }
    }

    private void scroll(int amount) {
        this.setScrollAmount(this.getScrollAmount() + (double)amount);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double amount) {
        this.scrollAmount = class_3532.method_15350((double)amount, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.field_22759 - 4));
    }

    protected void updateScrollingState(double mouseX, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPositionX() && mouseX < (double)(this.getScrollbarPositionX() + 6);
    }

    protected int getScrollbarPositionX() {
        return this.field_22758 / 2 + 124;
    }

    protected boolean isSelectButton(int button) {
        return button == 0;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.isSelectButton(button)) {
            return false;
        }
        this.updateScrollingState(mouseX, button);
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        E entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null && entry.method_25402(mouseX, mouseY, button)) {
            E entry2 = this.getFocused();
            if (entry2 != entry && entry2 instanceof class_4069) {
                class_4069 parentElement = (class_4069)entry2;
                parentElement.method_25395(null);
            }
            this.method_25395((class_364)entry);
            this.method_25398(true);
            return true;
        }
        return this.scrolling;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.getFocused() != null) {
            this.getFocused().method_25406(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.method_46427()) {
                this.setScrollAmount(0.0);
            } else if (mouseY > (double)WidgetHelper.getBottom(this)) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double d = Math.max(1, this.getMaxScroll());
                int i = WidgetHelper.getBottom(this) - this.method_46427();
                int j = class_3532.method_15340((int)((int)((float)(i * i) / (float)this.getMaxPosition())), (int)32, (int)(i - 8));
                double e = Math.max(1.0, d / (double)(i - j));
                this.setScrollAmount(this.getScrollAmount() + deltaY * e);
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.setScrollAmount(this.getScrollAmount() - amount * (double)this.itemHeight / 2.0);
        return true;
    }

    @Override
    public void method_25395(@Nullable class_364 focused) {
        super.method_25395(focused);
        int i = this.children.indexOf(focused);
        if (i >= 0) {
            Object entry = this.children.get(i);
            this.setSelected(entry);
            if (this.client.method_48186().method_48183()) {
                this.ensureVisible(entry);
            }
        }
    }

    @Nullable
    protected E getNeighboringEntry(class_8028 direction, Predicate<E> predicate, @Nullable E selected) {
        int i;
        switch (direction) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case field_41829: 
            case field_41828: {
                int n = 0;
                break;
            }
            case field_41826: {
                int n = -1;
                break;
            }
            case field_41827: {
                int n = i = 1;
            }
        }
        if (!this.method_25396().isEmpty() && i != 0) {
            int j = selected == null ? (i > 0 ? 0 : this.method_25396().size() - 1) : this.method_25396().indexOf(selected) + i;
            for (int k = j; k >= 0 && k < this.children.size(); k += i) {
                CustomEntry entry = (CustomEntry)this.method_25396().get(k);
                if (!predicate.test(entry)) continue;
                return (E)entry;
            }
        }
        return null;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseY >= (double)this.method_46427() && mouseY <= (double)WidgetHelper.getBottom(this) && mouseX >= (double)this.method_46426() && mouseX <= (double)WidgetHelper.getRight(this);
    }

    protected void renderList(class_332 context, int mouseX, int mouseY, float delta) {
        int i = this.getRowLeft();
        int j = this.getRowWidth();
        int k = this.itemHeight - 4;
        int l = this.getEntryCount();
        for (int m = 0; m < l; ++m) {
            int n = this.getRowTop(m);
            int o = this.getRowBottom(m);
            if (o < this.method_46427() || n > WidgetHelper.getBottom(this)) continue;
            this.renderEntry(context, mouseX, mouseY, delta, m, i, n, j, k);
        }
    }

    protected void renderEntry(class_332 context, int mouseX, int mouseY, float delta, int index, int x, int y, int entryWidth, int entryHeight) {
        E entry = this.getEntry(index);
        if (this.isSelectedEntry(index)) {
            int i = this.method_25370() ? -1 : -8355712;
            this.drawSelectionHighlight(context, y, entryWidth, entryHeight, i);
        }
        ((CustomEntry)entry).render(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, Objects.equals(this.hoveredEntry, entry), delta);
    }

    protected void drawSelectionHighlight(class_332 context, int y, int entryWidth, int entryHeight, int borderColor) {
        int i = this.method_46426() + (this.field_22758 - entryWidth) / 2;
        int j = this.method_46426() + (this.field_22758 + entryWidth) / 2;
        context.method_25294(i, y - 2, j, y + entryHeight + 2, borderColor);
        context.method_25294(i + 1, y - 1, j - 1, y + entryHeight + 1, -16777216);
    }

    public int getRowLeft() {
        return this.method_46426() + this.field_22758 / 2 - this.getRowWidth() / 2 + 2;
    }

    protected int getRowTop(int index) {
        return this.method_46427() + 4 - (int)this.getScrollAmount() + index * this.itemHeight + this.headerHeight;
    }

    protected int getRowBottom(int index) {
        return this.getRowTop(index) + this.itemHeight;
    }

    public class_6379.class_6380 method_37018() {
        if (this.method_25370()) {
            return class_6379.class_6380.field_33786;
        }
        return this.hoveredEntry != null ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    @Nullable
    protected E getHoveredEntry() {
        return this.hoveredEntry;
    }

    void setEntryParentList(CustomEntry<E> entry) {
        entry.parentList = this;
    }

    protected void appendNarrations(class_6382 builder, E entry) {
        int i;
        List<E> list = this.method_25396();
        if (list.size() > 1 && (i = list.indexOf(entry)) != -1) {
            builder.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.list", (Object[])new Object[]{i + 1, list.size()}));
        }
    }

    @Environment(value=EnvType.CLIENT)
    class Entries
    extends AbstractList<E> {
        private final List<E> entries = Lists.newArrayList();

        Entries() {
        }

        @Override
        public E get(int i) {
            return (CustomEntry)this.entries.get(i);
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        public E set(int i, E entry) {
            CustomEntry entry2 = (CustomEntry)this.entries.set(i, entry);
            CustomEntryListWidget.this.setEntryParentList(entry);
            return entry2;
        }

        @Override
        public void add(int i, E entry) {
            this.entries.add(i, entry);
            CustomEntryListWidget.this.setEntryParentList(entry);
        }

        @Override
        public E remove(int i) {
            return (CustomEntry)this.entries.remove(i);
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected static abstract class CustomEntry<E extends CustomEntry<E>>
    implements class_364 {
        @Deprecated
        CustomEntryListWidget<E> parentList;

        protected CustomEntry() {
        }

        public void method_25365(boolean focused) {
        }

        public boolean method_25370() {
            return this.parentList.getFocused() == this;
        }

        public abstract void render(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public boolean method_25405(double mouseX, double mouseY) {
            return Objects.equals(this.parentList.getEntryAtPosition(mouseX, mouseY), this);
        }
    }
}

