/*
 * Decompiled with CFR 0.152.
 */
package com.michaelsebero.shadeless;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="shadelessblocks", name="Shadeless Blocks", version="1.5", clientSideOnly=true, acceptedMinecraftVersions="[1.12.2]")
public class ShadelessBlocks {
    public static final String MODID = "shadelessblocks";
    public static final String NAME = "Shadeless Blocks";
    public static final String VERSION = "1.5";
    private static Constructor<?> bakedQuadConstructor;
    private static final Set<String> BLACKLISTED_MODS;
    private static final Set<String> WHITELISTED_MODELS;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelBake(ModelBakeEvent event) {
        System.out.println("[ShadelessBlocks] Removing shading from block models...");
        if (bakedQuadConstructor == null) {
            System.err.println("[ShadelessBlocks] Cannot proceed - BakedQuad constructor not found!");
            return;
        }
        int processedModels = 0;
        int skippedModels = 0;
        for (ModelResourceLocation key : event.getModelRegistry().func_148742_b()) {
            if (key.func_177518_c().equals("inventory")) continue;
            String resourceDomain = key.func_110624_b();
            if (BLACKLISTED_MODS.contains(resourceDomain)) {
                ++skippedModels;
                continue;
            }
            IBakedModel originalModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)key);
            if (originalModel == null) continue;
            if (this.isSafeToWrap(originalModel, key)) {
                try {
                    ShadelessModelWrapper shadelessModel = new ShadelessModelWrapper(originalModel);
                    event.getModelRegistry().func_82595_a((Object)key, (Object)shadelessModel);
                    ++processedModels;
                }
                catch (Exception e) {
                    System.err.println("[ShadelessBlocks] Failed to wrap model: " + key);
                    ++skippedModels;
                }
                continue;
            }
            ++skippedModels;
        }
        System.out.println("[ShadelessBlocks] Processed " + processedModels + " models, skipped " + skippedModels + " incompatible models");
    }

    private boolean isSafeToWrap(IBakedModel model, ModelResourceLocation location) {
        String className = model.getClass().getName();
        String simpleClassName = model.getClass().getSimpleName();
        String resourceDomain = location.func_110624_b();
        if (WHITELISTED_MODELS.contains(simpleClassName)) {
            System.out.println("[ShadelessBlocks] Whitelisted model: " + simpleClassName + " for " + location);
            return true;
        }
        if (resourceDomain.equals("gregtech")) {
            System.out.println("[ShadelessBlocks] Processing GregTech model: " + simpleClassName + " for " + location);
            try {
                if (model.func_188618_c()) {
                    System.out.println("[ShadelessBlocks] Skipping GregTech built-in renderer for " + location);
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        if (!(simpleClassName.equals("SimpleBakedModel") || simpleClassName.equals("WeightedBakedModel") || simpleClassName.equals("MultipartBakedModel") || simpleClassName.equals("BuiltInModel") || className.startsWith("net.minecraft.client.renderer.block.model") || className.contains("ModelWrapper") || className.contains("forge") && (className.contains("MultiLayerModel") || className.contains("ItemLayerModel") || className.contains("PerspectiveMapWrapper")))) {
            return false;
        }
        try {
            if (model.func_188618_c()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        try {
            List testQuads = model.func_188616_a(null, null, 0L);
            if (testQuads == null) {
                return true;
            }
            if (!testQuads.isEmpty()) {
                BakedQuad testQuad = (BakedQuad)testQuads.get(0);
                if (testQuad == null) {
                    return false;
                }
                testQuad.func_178209_a();
                testQuad.func_178210_d();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static BakedQuad createShadelessQuad(BakedQuad original) {
        if (bakedQuadConstructor == null || original == null) {
            return original;
        }
        try {
            int[] originalData = original.func_178209_a();
            int[] newData = new int[originalData.length];
            System.arraycopy(originalData, 0, newData, 0, originalData.length);
            return (BakedQuad)bakedQuadConstructor.newInstance(newData, original.func_178211_c(), original.func_178210_d(), original.func_187508_a(), false, original.getFormat());
        }
        catch (Exception e) {
            return original;
        }
    }

    static {
        BLACKLISTED_MODS = new HashSet<String>();
        WHITELISTED_MODELS = new HashSet<String>();
        BLACKLISTED_MODS.add("appliedenergistics2");
        BLACKLISTED_MODS.add("ae2");
        BLACKLISTED_MODS.add("ic2");
        WHITELISTED_MODELS.add("BakedModelBlockBranchBasic");
        WHITELISTED_MODELS.add("BakedModelBlockBranchThick");
        WHITELISTED_MODELS.add("BakedModelBlockBranchCactus");
        try {
            Class<BakedQuad> bakedQuadClass = BakedQuad.class;
            bakedQuadConstructor = bakedQuadClass.getDeclaredConstructor(int[].class, Integer.TYPE, EnumFacing.class, TextureAtlasSprite.class, Boolean.TYPE, VertexFormat.class);
            bakedQuadConstructor.setAccessible(true);
            System.out.println("[ShadelessBlocks] Successfully found BakedQuad constructor!");
        }
        catch (Exception e) {
            System.err.println("[ShadelessBlocks] Failed to find BakedQuad constructor!");
            e.printStackTrace();
        }
    }

    private static class ShadelessModelWrapper
    implements IBakedModel {
        private final IBakedModel original;

        public ShadelessModelWrapper(IBakedModel original) {
            this.original = original;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            try {
                List originalQuads = this.original.func_188616_a(state, side, rand);
                if (originalQuads == null || originalQuads.isEmpty()) {
                    return originalQuads;
                }
                ArrayList<BakedQuad> shadelessQuads = new ArrayList<BakedQuad>(originalQuads.size());
                for (BakedQuad quad : originalQuads) {
                    if (quad == null) continue;
                    shadelessQuads.add(ShadelessBlocks.createShadelessQuad(quad));
                }
                return shadelessQuads;
            }
            catch (Exception e) {
                try {
                    return this.original.func_188616_a(state, side, rand);
                }
                catch (Exception e2) {
                    return new ArrayList<BakedQuad>();
                }
            }
        }

        public boolean func_177555_b() {
            try {
                return this.original.func_177555_b();
            }
            catch (Exception e) {
                return true;
            }
        }

        public boolean func_177556_c() {
            try {
                return this.original.func_177556_c();
            }
            catch (Exception e) {
                return true;
            }
        }

        public boolean func_188618_c() {
            try {
                return this.original.func_188618_c();
            }
            catch (Exception e) {
                return false;
            }
        }

        public TextureAtlasSprite func_177554_e() {
            try {
                return this.original.func_177554_e();
            }
            catch (Exception e) {
                return null;
            }
        }

        public ItemCameraTransforms func_177552_f() {
            try {
                return this.original.func_177552_f();
            }
            catch (Exception e) {
                return ItemCameraTransforms.field_178357_a;
            }
        }

        public ItemOverrideList func_188617_f() {
            try {
                return this.original.func_188617_f();
            }
            catch (Exception e) {
                return ItemOverrideList.field_188022_a;
            }
        }
    }
}

