/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.alligatorgar.mob;

import aquariusplayz.animalgarden.alligatorgar.mob.MobAnimations;
import aquariusplayz.animalgarden.alligatorgar.mob.ModMob;
import aquariusplayz.animalgarden.alligatorgar.mob.ModMobRenderState;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import org.joml.Vector3f;

public class ModMobModel
extends EntityModel<ModMobRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.tryBuild((String)"animalgarden_alligatorgar", (String)"mob"), "main");
    private final ModelPart rootz;
    private final ModelPart body;
    private final ModelPart leftEyeLid;
    private final ModelPart rightEyeLid;
    private final ModelPart leftEye;
    private final ModelPart leftEyeBall;
    private final ModelPart rightEye;
    private final ModelPart rightEyeBall;
    private final ModelPart head;
    private final ModelPart mouth;
    private final ModelPart body2;
    private final ModelPart rightPelvicFin;
    private final ModelPart leftPelvicFin;
    private final ModelPart body3;
    private final ModelPart analFin;
    private final ModelPart body4;
    private final ModelPart caudalFin;
    private final ModelPart BackDorsalFin;
    private final ModelPart leftPectoralFin;
    private final ModelPart rightPectoralFin;
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public ModMobModel(ModelPart root) {
        super(root);
        this.rootz = root.getChild("rootz");
        this.body = this.rootz.getChild("body");
        this.leftEyeLid = this.body.getChild("leftEyeLid");
        this.rightEyeLid = this.body.getChild("rightEyeLid");
        this.leftEye = this.body.getChild("leftEye");
        this.leftEyeBall = this.leftEye.getChild("leftEyeBall");
        this.rightEye = this.body.getChild("rightEye");
        this.rightEyeBall = this.rightEye.getChild("rightEyeBall");
        this.head = this.body.getChild("head");
        this.mouth = this.head.getChild("mouth");
        this.body2 = this.body.getChild("body2");
        this.rightPelvicFin = this.body2.getChild("rightPelvicFin");
        this.leftPelvicFin = this.body2.getChild("leftPelvicFin");
        this.body3 = this.body2.getChild("body3");
        this.analFin = this.body3.getChild("analFin");
        this.body4 = this.body3.getChild("body4");
        this.caudalFin = this.body4.getChild("caudalFin");
        this.BackDorsalFin = this.body3.getChild("BackDorsalFin");
        this.leftPectoralFin = this.body.getChild("leftPectoralFin");
        this.rightPectoralFin = this.body.getChild("rightPectoralFin");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition rootz = partdefinition.addOrReplaceChild("rootz", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)27.0f, (float)0.0f));
        PartDefinition body = rootz.addOrReplaceChild("body", CubeListBuilder.create().texOffs(73, 20).addBox(-3.0f, -3.0f, -1.0f, 6.0f, 7.0f, 10.0f, new CubeDeformation(0.05f)), PartPose.offset((float)0.0f, (float)-7.5f, (float)-8.0f));
        PartDefinition leftEyeLid = body.addOrReplaceChild("leftEyeLid", CubeListBuilder.create().texOffs(86, 60).addBox(-0.46f, -2.45f, -1.55f, 1.0f, 3.0f, 3.0f, new CubeDeformation(-0.55f)), PartPose.offset((float)2.85f, (float)1.95f, (float)0.0f));
        PartDefinition rightEyeLid = body.addOrReplaceChild("rightEyeLid", CubeListBuilder.create().texOffs(81, 83).addBox(-0.54f, -2.45f, -1.55f, 1.0f, 3.0f, 3.0f, new CubeDeformation(-0.55f)), PartPose.offset((float)-2.85f, (float)1.95f, (float)0.0f));
        PartDefinition leftEye = body.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(86, 67).addBox(-1.56f, -2.0f, -10.05f, 1.0f, 3.0f, 3.0f, new CubeDeformation(-0.57f)), PartPose.offset((float)4.15f, (float)1.5f, (float)8.5f));
        PartDefinition leftEyeBall = leftEye.addOrReplaceChild("leftEyeBall", CubeListBuilder.create().texOffs(90, 55).addBox(-1.14f, -1.0f, -10.55f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.7f)), PartPose.offset((float)-1.13f, (float)-0.5f, (float)1.0f));
        PartDefinition rightEye = body.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(86, 74).addBox(-1.44f, -2.0f, -10.05f, 1.0f, 3.0f, 3.0f, new CubeDeformation(-0.57f)), PartPose.offset((float)-2.15f, (float)1.5f, (float)8.5f));
        PartDefinition rightEyeBall = rightEye.addOrReplaceChild("rightEyeBall", CubeListBuilder.create().texOffs(90, 81).addBox(-0.86f, -1.0f, -10.55f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.7f)), PartPose.offset((float)-0.87f, (float)-0.5f, (float)1.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 64).addBox(-3.0f, -2.5f, -13.0f, 6.0f, 3.0f, 15.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-7.0f, -3.61f, -16.85f, 14.0f, 9.0f, 22.0f, new CubeDeformation(-4.1f)), PartPose.offset((float)0.0f, (float)0.7f, (float)-1.0f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(43, 64).addBox(-3.0f, 3.0f, -18.0f, 6.0f, 3.0f, 15.0f, new CubeDeformation(-0.06f)).texOffs(0, 32).addBox(-7.0f, -1.78f, -22.0f, 14.0f, 9.0f, 22.0f, new CubeDeformation(-4.15f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.6f, (float)5.0f, (float)0.0087f, (float)0.0f, (float)0.0f));
        PartDefinition body2 = body.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(73, 0).addBox(-3.0f, -3.5f, -1.0f, 6.0f, 7.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)9.0f));
        PartDefinition rightPelvicFin = body2.addOrReplaceChild("rightPelvicFin", CubeListBuilder.create().texOffs(73, 52).addBox(-4.25f, -0.5f, -1.0f, 6.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(73, 60).addBox(-2.25f, -0.5f, 1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.75f, (float)3.5f, (float)6.0f, (float)0.0f, (float)0.5672f, (float)-0.7854f));
        PartDefinition leftPelvicFin = body2.addOrReplaceChild("leftPelvicFin", CubeListBuilder.create().texOffs(73, 56).addBox(-2.0f, -0.5f, -1.0f, 6.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(90, 52).addBox(-2.0f, -0.5f, 1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.75f, (float)3.5f, (float)6.0f, (float)0.0f, (float)-0.5672f, (float)0.7854f));
        PartDefinition body3 = body2.addOrReplaceChild("body3", CubeListBuilder.create().texOffs(73, 38).addBox(-2.5f, -3.0f, -1.0f, 5.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)11.0f));
        PartDefinition analFin = body3.addOrReplaceChild("analFin", CubeListBuilder.create().texOffs(45, 83).addBox(-0.5f, -1.2233f, -0.8693f, 1.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(59, 93).addBox(-0.5f, -0.2233f, 2.1307f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)1.25f, (float)0.9163f, (float)0.0f, (float)0.0f));
        PartDefinition body4 = body3.addOrReplaceChild("body4", CubeListBuilder.create().texOffs(0, 83).addBox(-2.0f, -2.5f, -2.0f, 4.0f, 5.0f, 7.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)6.0f));
        PartDefinition caudalFin = body4.addOrReplaceChild("caudalFin", CubeListBuilder.create().texOffs(72, 83).addBox(-0.5f, -3.0f, -0.75f, 1.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(23, 83).addBox(-0.5f, -4.0f, 2.25f, 1.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(86, 90).addBox(-0.5f, -3.0f, 7.25f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)4.75f));
        PartDefinition BackDorsalFin = body3.addOrReplaceChild("BackDorsalFin", CubeListBuilder.create().texOffs(81, 90).addBox(0.0f, -5.2765f, 2.4903f, 1.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(36, 83).addBox(0.0f, -6.2765f, -0.5097f, 1.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-3.0f, (float)2.0f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition leftPectoralFin = body.addOrReplaceChild("leftPectoralFin", CubeListBuilder.create().texOffs(63, 83).addBox(0.0f, -1.0f, -2.2321f, 1.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(54, 93).addBox(0.0f, -1.0f, 0.7679f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)3.75f, (float)4.5f, (float)0.5236f, (float)0.0f, (float)-1.0472f));
        PartDefinition rightPectoralFin = body.addOrReplaceChild("rightPectoralFin", CubeListBuilder.create().texOffs(54, 83).addBox(-1.0f, -1.0f, -2.2321f, 1.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(91, 86).addBox(-1.0f, -1.0f, 0.7679f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)3.75f, (float)4.5f, (float)0.5236f, (float)0.0f, (float)1.0472f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(ModMobRenderState p_368486_) {
        super.setupAnim((EntityRenderState)p_368486_);
        ModMob mob = p_368486_.entity;
        float pitch = mob.getXRot() == 0.0f ? 0.001f : mob.getXRot();
        this.rootz.xRot = mob.fakeXRot = Mth.rotLerp((float)0.1f, (float)mob.fakeXRot, (float)(pitch / 60.0f));
        this.animate(mob.bite, MobAnimations.bite, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.lookDown, MobAnimations.lookDown, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.lookUp, MobAnimations.lookUp, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.lookForward, MobAnimations.lookForward, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.lookBack, MobAnimations.lookBack, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.wink, MobAnimations.wink, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.breathe, MobAnimations.breathe, p_368486_.ageInTicks, 1.0f);
        if (!mob.isInWater()) {
            this.animateWalk(MobAnimations.swimming, p_368486_.walkAnimationPos, p_368486_.walkAnimationSpeed, 25.0f, 25.0f);
        } else {
            this.animateWalk(MobAnimations.swimming, p_368486_.walkAnimationPos, p_368486_.walkAnimationSpeed, 6.0f, 25.0f);
        }
    }

    protected void animate(AnimationState p_361867_, AnimationDefinition p_365477_, float p_361961_) {
        this.animate(p_361867_, p_365477_, p_361961_, 1.0f);
    }

    protected void animateWalk(AnimationDefinition p_363127_, float p_364817_, float p_364163_, float p_365350_, float p_365167_) {
        long i = (long)(p_364817_ * 50.0f * p_365350_);
        float f = Math.min(p_364163_ * p_365167_, 1.0f);
        ModMobModel.animate((Model)this, p_363127_, i, f, ANIMATION_VECTOR_CACHE);
    }

    protected void animate(AnimationState p_368871_, AnimationDefinition p_365491_, float p_363110_, float p_368202_) {
        p_368871_.ifStarted(p_368242_ -> ModMobModel.animate((Model)this, p_365491_, (long)((float)p_368242_.getTimeInMillis(p_363110_) * p_368202_), 1.0f, ANIMATION_VECTOR_CACHE));
    }

    protected void applyStatic(AnimationDefinition p_369884_) {
        ModMobModel.animate((Model)this, p_369884_, 0L, 1.0f, ANIMATION_VECTOR_CACHE);
    }

    public static Optional<ModelPart> getAnyDescendantWithName(Model p_362391_, String p_363872_) {
        Stream stream = p_362391_.root().getAllParts().toList().stream();
        return p_363872_.equals("root") ? Optional.of(p_362391_.root()) : stream.filter(p_364767_ -> p_364767_.hasChild(p_363872_)).findFirst().map(p_366385_ -> p_366385_.getChild(p_363872_));
    }

    public static void animate(Model p_362391_, AnimationDefinition p_232321_, long p_232322_, float p_232323_, Vector3f p_253861_) {
        float f = ModMobModel.getElapsedSeconds(p_232321_, p_232322_);
        for (Map.Entry entry : p_232321_.boneAnimations().entrySet()) {
            Optional<ModelPart> optional = ModMobModel.getAnyDescendantWithName(p_362391_, (String)entry.getKey());
            List list = (List)entry.getValue();
            optional.ifPresent(p_232330_ -> list.forEach(p_288241_ -> {
                Keyframe[] akeyframe = p_288241_.keyframes();
                int i = Math.max(0, Mth.binarySearch((int)0, (int)akeyframe.length, p_232315_ -> f <= akeyframe[p_232315_].timestamp()) - 1);
                int j = Math.min(akeyframe.length - 1, i + 1);
                Keyframe keyframe = akeyframe[i];
                Keyframe keyframe1 = akeyframe[j];
                float f1 = f - keyframe.timestamp();
                float f2 = j != i ? Mth.clamp((float)(f1 / (keyframe1.timestamp() - keyframe.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
                keyframe1.interpolation().apply(p_253861_, f2, akeyframe, i, j, p_232323_);
                p_288241_.target().apply(p_232330_, p_253861_);
            }));
        }
    }

    public static float getElapsedSeconds(AnimationDefinition p_232317_, long p_232318_) {
        float f = (float)p_232318_ / 1000.0f;
        return p_232317_.looping() ? f % p_232317_.lengthInSeconds() : f;
    }
}

