/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.alligatorgar.mob;

import aquariusplayz.animalgarden.alligatorgar.config.ModConfigs;
import aquariusplayz.animalgarden.alligatorgar.mob.ModAnimationState;
import aquariusplayz.animalgarden.alligatorgar.mob.controls.ModBodyRotationControl;
import aquariusplayz.animalgarden.alligatorgar.mob.controls.ModSmoothSwimmingLookControl;
import aquariusplayz.animalgarden.alligatorgar.mob.controls.ModSmoothSwimmingMoveControl;
import aquariusplayz.animalgarden.alligatorgar.mob.goals.ModGoToWaterGoal;
import aquariusplayz.animalgarden.alligatorgar.mob.goals.ModLeapAtTargetGoal;
import aquariusplayz.animalgarden.alligatorgar.mob.goals.ModMeleeAttackGoal;
import aquariusplayz.animalgarden.alligatorgar.mob.goals.ModMobPathNavigation;
import aquariusplayz.animalgarden.alligatorgar.mob.goals.ModRandomSwimmingOrWalkingGoal;
import aquariusplayz.animalgarden.alligatorgar.setup.Registrations;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AgeableWaterCreature;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ModMob
extends AgeableWaterCreature
implements NeutralMob {
    public static final Predicate<Entity> ALLOWED_ENTITIES = entity -> {
        ItemEntity ie;
        return entity.isAlive() && entity.isInWater() && entity instanceof ItemEntity && (ie = (ItemEntity)entity).getItem().is(Registrations.FOOD_ITEMS);
    };
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BODY_COLOR = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;
    public float fakeXRot;
    public final ModAnimationState wink = new ModAnimationState();
    public final ModAnimationState lookBack = new ModAnimationState();
    public final ModAnimationState lookForward = new ModAnimationState();
    public final ModAnimationState lookUp = new ModAnimationState();
    public final ModAnimationState lookDown = new ModAnimationState();
    public final ModAnimationState bite = new ModAnimationState();
    public final ModAnimationState breathe = new ModAnimationState();
    public ItemEntity foodItemEntity = null;

    public ModMob(EntityType<? extends ModMob> p_29362_, Level p_29363_) {
        super(p_29362_, p_29363_);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        if (this.isInWater()) {
            this.moveControl = new ModSmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.02f, true);
            this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 10);
        } else {
            this.moveControl = new MoveControl((Mob)this);
            this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 5);
        }
    }

    public static boolean checkSurfaceAgeableWaterCreatureSpawnRules(EntityType<? extends ModMob> p_369363_, ServerLevelAccessor p_370080_, EntitySpawnReason p_367384_, BlockPos p_370200_, RandomSource p_362509_) {
        if (p_362509_.nextInt(5) != 0) {
            return false;
        }
        List list = p_370080_.getLevel().getEntitiesOfClass(ModMob.class, new AABB(p_370200_).inflate(24.0));
        for (ModMob entity : list) {
            if (!entity.isAlive()) continue;
            return false;
        }
        int i = p_370080_.getSeaLevel();
        int j = i - 13;
        return p_370200_.getY() >= j && p_370200_.getY() <= i && p_370080_.getFluidState(p_370200_.below()).is(FluidTags.WATER) && p_370080_.getBlockState(p_370200_.above()).is(Blocks.WATER);
    }

    public void travel(Vec3 p_30218_) {
        if (this.isInWater()) {
            this.moveRelative(0.1f, p_30218_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.7));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(p_30218_);
        }
    }

    protected BodyRotationControl createBodyControl() {
        return new ModBodyRotationControl((Mob)this);
    }

    protected PathNavigation createNavigation(Level p_30171_) {
        return new ModMobPathNavigation(this, p_30171_);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ModMeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.goalSelector.addGoal(2, (Goal)new ModGoToWaterGoal(this, 0.8));
        this.goalSelector.addGoal(3, (Goal)new ModRandomSwimmingOrWalkingGoal((PathfinderMob)this, 1.0, 1));
        this.goalSelector.addGoal(4, (Goal)new ModLeapAtTargetGoal((Mob)this, 0.8f));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, (arg_0, arg_1) -> ((ModMob)this).isAngryAt(arg_0, arg_1)));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void setAirSupply(int p_20302_) {
    }

    public int getAirSupply() {
        return this.getMaxAirSupply();
    }

    public int getMaxAirSupply() {
        return 4800;
    }

    protected float getJumpPower() {
        return this.getJumpPower(1.5f);
    }

    public void aiStep() {
        Vec3 vec3;
        List list;
        super.aiStep();
        if (this.tickCount % 100 == 0) {
            if (this.getTarget() != null) {
                if (!this.getTarget().isInWater()) {
                    this.setTarget(null);
                }
            } else {
                if (!(this.foodItemEntity == null || this.foodItemEntity.isAlive() && this.foodItemEntity.isInWater() && !(this.getHealth() >= this.getMaxHealth()))) {
                    this.foodItemEntity = null;
                }
                if (this.foodItemEntity == null && this.getHealth() < this.getMaxHealth() && !(list = this.level().getEntitiesOfClass(Entity.class, this.getBoundingBox().inflate(16.0, 8.0, 16.0), ALLOWED_ENTITIES)).isEmpty()) {
                    list.forEach(entity -> {
                        if (entity != this && this.getSensing().hasLineOfSight(entity) && entity instanceof ItemEntity) {
                            ItemEntity e = (ItemEntity)entity;
                            if (this.foodItemEntity == null) {
                                this.foodItemEntity = e;
                            } else if (this.distanceToSqr((Entity)e) < this.distanceToSqr((Entity)this.foodItemEntity)) {
                                this.foodItemEntity = e;
                            }
                        }
                    });
                }
            }
        }
        if (this.foodItemEntity != null && this.getTarget() == null) {
            if (!this.foodItemEntity.isAlive() || !this.foodItemEntity.isInWater() || this.getHealth() >= this.getMaxHealth()) {
                this.foodItemEntity = null;
            } else {
                Level vec31;
                this.getLookControl().setLookAt((Entity)this.foodItemEntity, (float)(this.getMaxHeadYRot() + 20), (float)this.getMaxHeadXRot());
                if (this.tickCount % 40 == 0 && this.getAttackBoundingBox().inflate(3.0).intersects(this.foodItemEntity.getBoundingBox())) {
                    vec3 = this.getDeltaMovement();
                    vec31 = new Vec3(this.foodItemEntity.getX() - this.getX(), this.foodItemEntity.getEyeY() - this.getEyeY(), this.foodItemEntity.getZ() - this.getZ());
                    if (vec31.lengthSqr() > 1.0E-7) {
                        vec31 = vec31.normalize().scale(1.0).add(vec3.scale(1.0));
                    }
                    this.setDeltaMovement(vec31.x, vec31.y, vec31.z);
                }
                if (this.getAttackBoundingBox().inflate(0.1).intersects(this.foodItemEntity.getBoundingBox())) {
                    vec31 = this.level();
                    if (vec31 instanceof ServerLevel) {
                        ServerLevel level = (ServerLevel)vec31;
                        level.broadcastEntityEvent((Entity)this, (byte)4);
                        if (this.getHealth() < this.getMaxHealth()) {
                            this.heal(10.0f);
                        }
                        this.playSound(SoundEvents.FOX_BITE, 1.0f + this.getRandom().nextFloat(), this.getRandom().nextFloat() * 0.2f);
                        this.foodItemEntity.discard();
                    }
                    this.foodItemEntity = null;
                    this.getNavigation().stop();
                } else {
                    this.getNavigation().moveTo(this.foodItemEntity.getX(), this.foodItemEntity.getY(), this.foodItemEntity.getZ(), 1.75);
                }
            }
        }
        if (this.isInWater() && !(this.moveControl instanceof ModSmoothSwimmingMoveControl)) {
            this.moveControl = new ModSmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.02f, true);
            this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 10);
        } else if (!this.isInWater() && this.moveControl instanceof ModSmoothSwimmingMoveControl) {
            this.moveControl = new MoveControl((Mob)this);
            this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 5);
        }
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
            if (ModConfigs.randomAttackChance > 0 && this.isInWater() && this.getRandom().nextInt(ModConfigs.randomAttackChance) == 0 && this.getTarget() == null) {
                list = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(24.0, 12.0, 24.0));
                list.forEach(entity -> {
                    if (this != entity && entity.isAlive() && !entity.isInvulnerable() && !entity.isInvisible() && this.hasLineOfSight((Entity)entity)) {
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            if (!player.isCreative() && !player.isSpectator()) {
                                this.setTarget((LivingEntity)entity);
                                this.playSound((SoundEvent)Registrations.IDLE.get(), this.getSoundVolume() + 0.5f, this.getVoicePitch());
                            }
                        } else {
                            this.setTarget((LivingEntity)entity);
                            this.playSound((SoundEvent)Registrations.IDLE.get(), this.getSoundVolume() + 0.5f, this.getVoicePitch());
                        }
                    }
                });
            }
        } else {
            this.doDefaultBehaviors();
            if (this.isInWater() && this.getDeltaMovement().lengthSqr() > 0.02) {
                vec3 = this.getViewVector(0.0f);
                float f = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 1.2f;
                float f1 = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * 1.2f;
                float f2 = 0.7f - this.random.nextFloat() * 0.7f;
                for (int i = 0; i < 2; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vec3.x * (double)f2 + (double)f, this.getY() - vec3.y + (double)0.2f, this.getZ() - vec3.z * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                    this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vec3.x * (double)f2 - (double)f, this.getY() - vec3.y + (double)0.2f, this.getZ() - vec3.z * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private void doDefaultBehaviors() {
        Level level = this.level();
        if (!this.breathe.isStarted()) {
            this.breathe.start(this.tickCount);
        }
        if (this.bite.isStarted() && this.animationEnded(this.bite, 1.0f)) {
            this.bite.stop();
        }
        if (this.wink.isStarted() && this.animationEnded(this.wink, 1.25f)) {
            this.wink.stop();
        }
        if (!this.bite.isStarted() && level.random.nextInt(100) == 0 && this.animationEnded(this.wink, 1.25f)) {
            this.wink.start(this.tickCount);
        }
        if (level.random.nextInt(10) == 0 && this.animationEnded(this.lookUp, 1.75f) && this.animationEnded(this.lookDown, 1.75f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.lookUp.start(this.tickCount);
            } else {
                this.lookDown.start(this.tickCount);
            }
        }
        if (level.random.nextInt(10) == 0 && this.animationEnded(this.lookBack, 1.75f) && this.animationEnded(this.lookForward, 1.75f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.lookBack.start(this.tickCount);
            } else {
                this.lookForward.start(this.tickCount);
            }
        }
    }

    public boolean animationEnded(ModAnimationState state, float animLength) {
        return (float)state.getTimeInMillis(this.tickCount) > animLength * 1000.0f;
    }

    public boolean doHurtTarget(ServerLevel p_368649_, Entity p_32257_) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound(SoundEvents.FOX_BITE, this.getSoundVolume(), this.getRandom().nextFloat() * 0.2f);
        if (super.doHurtTarget(p_368649_, p_32257_)) {
            if (ModConfigs.attacksOnlyOnce) {
                this.stopBeingAngry();
            }
            return true;
        }
        return false;
    }

    public boolean hurtServer(ServerLevel p_395568_, DamageSource p_396024_, float p_394833_) {
        if (this.isInvulnerableTo(p_395568_, p_396024_)) {
            return false;
        }
        this.playSound((SoundEvent)Registrations.IDLE.get(), this.getSoundVolume(), this.getVoicePitch());
        return super.hurtServer(p_395568_, p_396024_, p_394833_);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, EntitySpawnReason p_366700_, SpawnGroupData p_146749_) {
        this.setBodyColor(this.getRandom().nextInt(4));
        return super.finalizeSpawn(p_146746_, p_146747_, p_366700_, p_146749_);
    }

    public float getWalkTargetValue(BlockPos p_33895_, LevelReader p_33896_) {
        return 10.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.FOLLOW_RANGE, 12.0).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    public boolean isPersistenceRequired() {
        if (ModConfigs.isAlwaysPersistent) {
            return true;
        }
        return this.hasCustomName() || super.isPersistenceRequired();
    }

    public boolean requiresCustomPersistence() {
        if (ModConfigs.isAlwaysPersistent) {
            return true;
        }
        return this.hasCustomName() || super.requiresCustomPersistence();
    }

    public boolean removeWhenFarAway(double p_27492_) {
        if (ModConfigs.isAlwaysPersistent) {
            return false;
        }
        return !this.hasCustomName();
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_335317_) {
        super.defineSynchedData(p_335317_);
        p_335317_.define(DATA_REMAINING_ANGER_TIME, (Object)0);
        p_335317_.define(BODY_COLOR, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag p_29422_) {
        super.addAdditionalSaveData(p_29422_);
        this.addPersistentAngerSaveData(p_29422_);
        p_29422_.putInt("BodyColor", this.getBodyColor());
    }

    public void readAdditionalSaveData(CompoundTag p_29402_) {
        super.readAdditionalSaveData(p_29402_);
        this.readPersistentAngerSaveData(this.level(), p_29402_);
        this.setBodyColor(p_29402_.getInt("BodyColor"));
    }

    public int getBodyColor() {
        return (Integer)this.entityData.get(BODY_COLOR);
    }

    private void setBodyColor(int p_30398_) {
        this.entityData.set(BODY_COLOR, (Object)p_30398_);
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int p_30404_) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    public void handleEntityEvent(byte p_397414_) {
        if (p_397414_ == 4) {
            if (this.animationEnded(this.bite, 1.0f)) {
                this.wink.stop();
                this.bite.start(this.tickCount);
            }
        } else {
            super.handleEntityEvent(p_397414_);
        }
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_148993_, AgeableMob p_148994_) {
        ModMob mob = (ModMob)this.getType().create((Level)p_148993_, EntitySpawnReason.BREEDING);
        mob.setBodyColor(this.getRandom().nextInt(4));
        return mob;
    }
}

