/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcspotifylink;

import com.mongenscave.mcspotifylink.boostedyaml.settings.dumper.DumperSettings;
import com.mongenscave.mcspotifylink.boostedyaml.settings.general.GeneralSettings;
import com.mongenscave.mcspotifylink.boostedyaml.settings.loader.LoaderSettings;
import com.mongenscave.mcspotifylink.boostedyaml.settings.updater.UpdaterSettings;
import com.mongenscave.mcspotifylink.config.Config;
import com.mongenscave.mcspotifylink.database.Database;
import com.mongenscave.mcspotifylink.database.impl.H2;
import com.mongenscave.mcspotifylink.database.impl.JSON;
import com.mongenscave.mcspotifylink.database.impl.MySQL;
import com.mongenscave.mcspotifylink.hooks.plugins.PlaceholderAPI;
import com.mongenscave.mcspotifylink.listeners.MenuListener;
import com.mongenscave.mcspotifylink.listeners.SpotifyListener;
import com.mongenscave.mcspotifylink.manager.SpotifyManager;
import com.mongenscave.mcspotifylink.manager.TimestampManager;
import com.mongenscave.mcspotifylink.server.WebServer;
import com.mongenscave.mcspotifylink.universalScheduler.UniversalScheduler;
import com.mongenscave.mcspotifylink.universalScheduler.scheduling.schedulers.TaskScheduler;
import com.mongenscave.mcspotifylink.utils.LoggerUtils;
import com.mongenscave.mcspotifylink.utils.RegisterUtils;
import com.mongenscave.mcspotifylink.zapper.ZapperJavaPlugin;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class McSpotifyLink
extends ZapperJavaPlugin {
    private static McSpotifyLink instance;
    private Config language;
    private Config guis;
    private TaskScheduler scheduler;
    private Database database;
    WebServer webServer;
    SpotifyManager spotifyManager;
    TimestampManager timestampManager;
    private Config config;

    public void onLoad() {
        instance = this;
        this.scheduler = UniversalScheduler.getScheduler((Plugin)this);
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.initializeComponents();
        this.initializeDatabase();
        this.spotifyManager = new SpotifyManager();
        this.webServer = new WebServer();
        this.timestampManager = new TimestampManager();
        this.getServer().getPluginManager().registerEvents((Listener)new SpotifyListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MenuListener(), (Plugin)this);
        this.webServer.start();
        RegisterUtils.startUpdateTask();
        RegisterUtils.registerCommands();
        PlaceholderAPI.registerHook();
    }

    public void onDisable() {
        CompletionStage<Object> shutdownFuture = CompletableFuture.completedFuture(null);
        if (this.database != null) {
            shutdownFuture = this.database.close().exceptionally(throwable -> {
                LoggerUtils.error("Error closing database: " + throwable.getMessage(), new Object[0]);
                return null;
            });
        }
        ((CompletableFuture)shutdownFuture).thenRun(() -> {
            if (this.spotifyManager != null) {
                this.spotifyManager.shutdown();
            }
            if (this.webServer != null) {
                this.webServer.stop();
            }
            if (this.timestampManager != null) {
                this.timestampManager.stopTimestampUpdates();
            }
        });
        try {
            ((CompletableFuture)shutdownFuture).get(5L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            LoggerUtils.error("Error during shutdown: " + exception.getMessage(), new Object[0]);
        }
    }

    public Config getConfiguration() {
        return this.config;
    }

    private void initializeComponents() {
        GeneralSettings generalSettings = GeneralSettings.builder().setUseDefaults(false).build();
        LoaderSettings loaderSettings = LoaderSettings.builder().setAutoUpdate(true).build();
        UpdaterSettings updaterSettings = UpdaterSettings.builder().setKeepAll(true).build();
        this.config = this.loadConfig("config.yml", generalSettings, loaderSettings, updaterSettings);
        this.language = this.loadConfig("messages.yml", generalSettings, loaderSettings, updaterSettings);
        this.guis = this.loadConfig("guis.yml", generalSettings, loaderSettings, updaterSettings);
    }

    @NotNull
    @Contract(value="_, _, _, _ -> new")
    private Config loadConfig(@NotNull String fileName, @NotNull GeneralSettings generalSettings, @NotNull LoaderSettings loaderSettings, @NotNull UpdaterSettings updaterSettings) {
        return new Config(new File(this.getDataFolder(), fileName), this.getResource(fileName), generalSettings, loaderSettings, DumperSettings.DEFAULT, updaterSettings);
    }

    private void initializeDatabase() {
        String databaseType;
        switch (databaseType = this.config.getString("database.type").toLowerCase()) {
            case "mysql": {
                String host = this.config.getString("database.mysql.host");
                int port = this.config.getInt("database.mysql.port");
                String databaseName = this.config.getString("database.mysql.database");
                String username = this.config.getString("database.mysql.username");
                String password = this.config.getString("database.mysql.password");
                int poolSize = this.config.getInt("database.mysql.pool-size");
                this.database = new MySQL(host, port, databaseName, username, password, poolSize);
                break;
            }
            case "h2": {
                this.database = new H2();
                break;
            }
            case "json": {
                this.database = new JSON();
                break;
            }
            default: {
                LoggerUtils.error("Unsupported database type: " + databaseType, new Object[0]);
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
            }
        }
    }

    @Generated
    public static McSpotifyLink getInstance() {
        return instance;
    }

    @Generated
    public Config getLanguage() {
        return this.language;
    }

    @Generated
    public Config getGuis() {
        return this.guis;
    }

    @Generated
    public TaskScheduler getScheduler() {
        return this.scheduler;
    }

    @Generated
    public Database getDatabase() {
        return this.database;
    }

    @Generated
    public WebServer getWebServer() {
        return this.webServer;
    }

    @Generated
    public SpotifyManager getSpotifyManager() {
        return this.spotifyManager;
    }

    @Generated
    public TimestampManager getTimestampManager() {
        return this.timestampManager;
    }
}

