/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcspotifylink.commands;

import com.mongenscave.mcspotifylink.McSpotifyLink;
import com.mongenscave.mcspotifylink.data.common.MenuController;
import com.mongenscave.mcspotifylink.gui.models.NavigationMenu;
import com.mongenscave.mcspotifylink.identifiers.keys.MessageKeys;
import com.mongenscave.mcspotifylink.manager.SpotifyManager;
import com.mongenscave.mcspotifylink.model.CurrentTrack;
import com.mongenscave.mcspotifylink.processor.MessageProcessor;
import com.mongenscave.mcspotifylink.utils.LoggerUtils;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.coma112.easiermessages.EasierMessages;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.annotation.CommandPlaceholder;
import revxrsal.commands.annotation.Subcommand;
import revxrsal.commands.bukkit.annotation.CommandPermission;
import revxrsal.commands.orphan.OrphanCommand;

public class CommandSpotify
implements OrphanCommand {
    private static final McSpotifyLink plugin = McSpotifyLink.getInstance();

    @CommandPlaceholder
    public void defaultCommand(@NotNull CommandSender sender) {
        for (String line : MessageKeys.HELP.getMessages()) {
            sender.sendMessage(MessageProcessor.process(line));
        }
    }

    @Subcommand(value={"menu"})
    @CommandPermission(value="spotifylink.menu")
    public void menu(@NotNull Player player) {
        if (!plugin.getSpotifyManager().isConnected(player)) {
            player.sendMessage(MessageKeys.NOT_CONNECTED.getMessage());
            return;
        }
        MenuController menuController = MenuController.getMenuUtils(player);
        new NavigationMenu(menuController).open();
    }

    @Subcommand(value={"reload"})
    @CommandPermission(value="spotifylink.reload")
    public void reload(@NotNull CommandSender sender) {
        plugin.getConfiguration().reload();
        plugin.getLanguage().reload();
        plugin.getGuis().reload();
        sender.sendMessage(MessageKeys.RELOAD.getMessage());
    }

    @Subcommand(value={"connect"})
    @CommandPermission(value="spotifylink.connect")
    public void connect(@NotNull Player player) {
        if (plugin.getSpotifyManager().isConnected(player)) {
            player.sendMessage(MessageKeys.ALREADY_CONNECTED.getMessage());
            return;
        }
        String authURL = plugin.getSpotifyManager().getAuthorizationUrl(player);
        for (String line : MessageKeys.CONNECT.getMessages()) {
            String processedLine = line.replace("{authURL}", authURL);
            Component component = EasierMessages.translateMessage((String)processedLine).build();
            player.sendMessage(component);
        }
    }

    @Subcommand(value={"disconnect"})
    @CommandPermission(value="spotifylink.disconnect")
    public void disconnect(@NotNull Player player) {
        if (!plugin.getSpotifyManager().isConnected(player)) {
            player.sendMessage(MessageKeys.NOT_CONNECTED.getMessage());
            return;
        }
        ((CompletableFuture)plugin.getSpotifyManager().disconnectUser(player).thenRun(() -> player.sendMessage(MessageKeys.DISCONNECTED.getMessage()))).exceptionally(exception -> {
            LoggerUtils.error(exception.getMessage(), new Object[0]);
            return null;
        });
    }

    @Subcommand(value={"status"})
    @CommandPermission(value="spotifylink.status")
    public void status(@NotNull Player player) {
        if (!plugin.getSpotifyManager().isConnected(player)) {
            player.sendMessage(MessageKeys.NOT_CONNECTED.getMessage());
            return;
        }
        CurrentTrack track = plugin.getSpotifyManager().getCurrentTrack(player);
        if (track != null) {
            for (String line : MessageKeys.CURRENT_LISTENING.getMessages()) {
                player.sendMessage(MessageProcessor.process(line).replace("{song}", track.getTrackName()).replace("{author}", track.getArtistName()));
            }
        } else {
            player.sendMessage(MessageKeys.NOT_LISTENING.getMessage());
        }
    }

    @Subcommand(value={"control action play"})
    @CommandPermission(value="spotifylink.control.play")
    public void controlPlay(@NotNull Player player) {
        this.handleControlAction(player, sm -> sm.resumePlayback(player));
    }

    @Subcommand(value={"control action pause"})
    @CommandPermission(value="spotifylink.control.pause")
    public void controlPause(@NotNull Player player) {
        this.handleControlAction(player, sm -> sm.pausePlayback(player));
    }

    @Subcommand(value={"control action next"})
    @CommandPermission(value="spotifylink.control.next")
    public void controlNext(@NotNull Player player) {
        this.handleControlAction(player, sm -> sm.nextTrack(player));
    }

    @Subcommand(value={"control action previous"})
    @CommandPermission(value="spotifylink.control.previous")
    public void controlPrevious(@NotNull Player player) {
        this.handleControlAction(player, sm -> sm.previousTrack(player));
    }

    @Subcommand(value={"control"})
    public void control(@NotNull Player player) {
        if (!plugin.getSpotifyManager().isConnected(player)) {
            player.sendMessage(MessageKeys.NOT_CONNECTED.getMessage());
            return;
        }
        for (String line : MessageKeys.CONTROL.getMessages()) {
            Component component = EasierMessages.translateMessage((String)line).build();
            player.sendMessage(component);
        }
    }

    private void handleControlAction(@NotNull Player player, @NotNull Function<SpotifyManager, CompletableFuture<Void>> action) {
        if (!plugin.getSpotifyManager().isConnected(player)) {
            player.sendMessage(MessageKeys.NOT_CONNECTED.getMessage());
            return;
        }
        ((CompletableFuture)action.apply(plugin.getSpotifyManager()).thenRun(() -> plugin.getScheduler().runTask(() -> plugin.getSpotifyManager().updatePlayer(player)))).exceptionally(exception -> null);
    }
}

