/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcspotifylink.database.impl;

import com.mongenscave.mcspotifylink.McSpotifyLink;
import com.mongenscave.mcspotifylink.data.spotify.SpotifyUser;
import com.mongenscave.mcspotifylink.database.Database;
import com.mongenscave.mcspotifylink.gson.Gson;
import com.mongenscave.mcspotifylink.gson.GsonBuilder;
import com.mongenscave.mcspotifylink.gson.reflect.TypeToken;
import com.mongenscave.mcspotifylink.utils.LoggerUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

public class JSON
implements Database {
    private static final McSpotifyLink plugin = McSpotifyLink.getInstance();
    private final File dataFile;
    private final Gson gson;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Executor executor = Executors.newFixedThreadPool(3);

    public JSON() {
        this.dataFile = new File(plugin.getDataFolder(), "spotify_users.json");
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.initializeDatabase();
    }

    @Override
    public void initializeDatabase() {
        CompletableFuture.runAsync(() -> {
            if (!this.dataFile.exists()) {
                try {
                    if (!this.dataFile.getParentFile().exists()) {
                        this.dataFile.getParentFile().mkdirs();
                    }
                    this.dataFile.createNewFile();
                    try (FileWriter writer = new FileWriter(this.dataFile);){
                        writer.write("{}");
                    }
                }
                catch (IOException exception) {
                    LoggerUtils.error(exception.getMessage(), new Object[0]);
                    throw new RuntimeException(exception);
                }
            }
        }, this.executor);
    }

    @Override
    public CompletableFuture<Void> saveUser(@NotNull SpotifyUser user) {
        return CompletableFuture.runAsync(() -> {
            this.lock.writeLock().lock();
            try {
                ConcurrentHashMap<String, SpotifyUser> users = this.loadUsersFromFileSync();
                users.put(user.playerId().toString(), user);
                this.saveUsersToFileSync(users);
            }
            catch (Exception exception) {
                LoggerUtils.error(exception.getMessage(), new Object[0]);
                throw new RuntimeException(exception);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }, this.executor);
    }

    @Override
    public CompletableFuture<ConcurrentHashMap<UUID, SpotifyUser>> loadUsers() {
        return CompletableFuture.supplyAsync(() -> {
            ConcurrentHashMap<UUID, SpotifyUser> users = new ConcurrentHashMap<UUID, SpotifyUser>();
            this.lock.readLock().lock();
            try {
                ConcurrentHashMap<String, SpotifyUser> userData = this.loadUsersFromFileSync();
                for (Map.Entry<String, SpotifyUser> entry : userData.entrySet()) {
                    try {
                        UUID playerId = UUID.fromString(entry.getKey());
                        SpotifyUser user = entry.getValue();
                        if (user == null) continue;
                        users.put(playerId, user);
                    }
                    catch (Exception exception) {
                        LoggerUtils.error(exception.getMessage(), new Object[0]);
                    }
                }
            }
            catch (Exception exception) {
                LoggerUtils.error(exception.getMessage(), new Object[0]);
                throw new RuntimeException(exception);
            }
            finally {
                this.lock.readLock().unlock();
            }
            return users;
        }, this.executor);
    }

    @Override
    public CompletableFuture<Void> removeUser(@NotNull UUID playerId) {
        return CompletableFuture.runAsync(() -> {
            this.lock.writeLock().lock();
            try {
                ConcurrentHashMap<String, SpotifyUser> users = this.loadUsersFromFileSync();
                users.remove(playerId.toString());
                this.saveUsersToFileSync(users);
            }
            catch (Exception exception) {
                LoggerUtils.error(exception.getMessage(), new Object[0]);
                throw new RuntimeException(exception);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }, this.executor);
    }

    @NotNull
    private ConcurrentHashMap<String, SpotifyUser> loadUsersFromFileSync() {
        ConcurrentHashMap concurrentHashMap;
        if (!this.dataFile.exists() || this.dataFile.length() == 0L) {
            return new ConcurrentHashMap<String, SpotifyUser>();
        }
        FileReader reader = new FileReader(this.dataFile);
        try {
            Type type = new TypeToken<ConcurrentHashMap<String, SpotifyUser>>(this){}.getType();
            ConcurrentHashMap result = (ConcurrentHashMap)this.gson.fromJson((Reader)reader, type);
            concurrentHashMap = result != null ? result : new ConcurrentHashMap();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                LoggerUtils.error("Hiba a JSON f\u00e1jl olvas\u00e1sa sor\u00e1n: " + exception.getMessage(), new Object[0]);
                return new ConcurrentHashMap<String, SpotifyUser>();
            }
        }
        reader.close();
        return concurrentHashMap;
    }

    private void saveUsersToFileSync(ConcurrentHashMap<String, SpotifyUser> users) {
        try (FileWriter writer = new FileWriter(this.dataFile);){
            this.gson.toJson(users, (Appendable)writer);
        }
        catch (IOException exception) {
            LoggerUtils.error("Hiba a JSON f\u00e1jl \u00edr\u00e1sa sor\u00e1n: " + exception.getMessage(), new Object[0]);
            throw new RuntimeException(exception);
        }
    }

    @Override
    public CompletableFuture<Void> close() {
        return CompletableFuture.runAsync(() -> {}, this.executor);
    }
}

