/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcspotifylink.gui;

import com.mongenscave.mcspotifylink.data.common.MenuController;
import com.mongenscave.mcspotifylink.processor.MenuProcessor;
import com.mongenscave.mcspotifylink.processor.MessageProcessor;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public abstract class Menu
implements InventoryHolder {
    public MenuController menuController;
    protected Inventory inventory;

    public Menu(@NotNull MenuController menuController) {
        this.menuController = menuController;
    }

    public abstract void handleMenu(@NotNull InventoryClickEvent var1);

    public abstract void setMenuItems();

    public abstract String getMenuName();

    public abstract int getSlots();

    public abstract int getMenuTick();

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void open() {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.getSlots(), (String)MessageProcessor.process(this.getMenuName()));
        this.setMenuItems();
        this.menuController.owner().openInventory(this.inventory);
        MenuProcessor menuUpdater = new MenuProcessor(this);
        menuUpdater.start(this.getMenuTick());
    }

    public void close() {
        MenuProcessor menuUpdater = new MenuProcessor(this);
        menuUpdater.stop();
        MenuController.remove(this.menuController.owner());
        this.inventory = null;
    }

    public void updateMenuItems() {
        if (this.inventory == null) {
            return;
        }
        this.setMenuItems();
        this.menuController.owner().updateInventory();
    }
}

