/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcspotifylink.gui.models;

import com.mongenscave.mcspotifylink.McSpotifyLink;
import com.mongenscave.mcspotifylink.data.common.MenuController;
import com.mongenscave.mcspotifylink.gui.Menu;
import com.mongenscave.mcspotifylink.gui.models.NavigationMenu;
import com.mongenscave.mcspotifylink.identifiers.keys.ItemKeys;
import com.mongenscave.mcspotifylink.identifiers.keys.MenuKeys;
import com.mongenscave.mcspotifylink.identifiers.keys.MessageKeys;
import com.mongenscave.mcspotifylink.item.ItemFactory;
import com.mongenscave.mcspotifylink.manager.SpotifyManager;
import com.mongenscave.mcspotifylink.utils.LoggerUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ControlsMenu
extends Menu {
    private static final McSpotifyLink plugin = McSpotifyLink.getInstance();
    private final ConcurrentHashMap<Integer, ItemKeys> slotToItemKeyMap = new ConcurrentHashMap();

    public ControlsMenu(@NotNull MenuController menuController) {
        super(menuController);
    }

    @Override
    public void handleMenu(@NotNull InventoryClickEvent event) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        int slot = event.getSlot();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        ItemKeys clickedItemKey = this.slotToItemKeyMap.get(slot);
        SpotifyManager spotifyManager = plugin.getSpotifyManager();
        if (clickedItemKey != null) {
            event.setCancelled(true);
            Player player = this.menuController.owner();
            switch (clickedItemKey) {
                case CONTROLS_BACK: {
                    new NavigationMenu(this.menuController).open();
                    break;
                }
                case CONTROLS_NEXT: {
                    this.handleAsyncAction(player, spotifyManager::nextTrack);
                    break;
                }
                case CONTROLS_PAUSE: {
                    this.handleAsyncAction(player, spotifyManager::pausePlayback);
                    break;
                }
                case CONTROLS_PLAY: {
                    this.handleAsyncAction(player, spotifyManager::resumePlayback);
                    break;
                }
                case CONTROLS_PREVIOUS: {
                    this.handleAsyncAction(player, spotifyManager::previousTrack);
                }
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        this.slotToItemKeyMap.clear();
        ItemFactory.setItemsForMenu("controls-menu.items", this.inventory);
        this.setMenuItem(ItemKeys.CONTROLS_BACK);
        this.setMenuItem(ItemKeys.CONTROLS_NEXT);
        this.setMenuItem(ItemKeys.CONTROLS_PAUSE);
        this.setMenuItem(ItemKeys.CONTROLS_PLAY);
        this.setMenuItem(ItemKeys.CONTROLS_PREVIOUS);
    }

    @Override
    public String getMenuName() {
        return MenuKeys.MENU_NAVIGATION_TITLE.getString();
    }

    @Override
    public int getSlots() {
        return MenuKeys.MENU_NAVIGATION_SIZE.getInt();
    }

    @Override
    public int getMenuTick() {
        return 20;
    }

    private void setMenuItem(@NotNull ItemKeys itemKey) {
        ItemStack item = itemKey.getItem();
        if (item == null) {
            return;
        }
        int slot = itemKey.getSlot();
        this.inventory.setItem(slot, item);
        this.slotToItemKeyMap.put(slot, itemKey);
    }

    private void handleAsyncAction(Player player, Function<Player, CompletableFuture<Void>> action) {
        if (!plugin.getSpotifyManager().isConnected(player)) {
            player.sendMessage(MessageKeys.NOT_CONNECTED.getMessage());
            return;
        }
        action.apply(player).whenComplete((result, exception) -> {
            if (exception != null) {
                LoggerUtils.error(exception.getMessage(), new Object[0]);
            } else {
                plugin.getScheduler().runTask(() -> plugin.getSpotifyManager().updatePlayer(player));
            }
        });
    }
}

