/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcspotifylink.gui.models;

import com.mongenscave.mcspotifylink.McSpotifyLink;
import com.mongenscave.mcspotifylink.data.common.MenuController;
import com.mongenscave.mcspotifylink.data.spotify.Playlist;
import com.mongenscave.mcspotifylink.gui.PaginatedMenu;
import com.mongenscave.mcspotifylink.gui.models.NavigationMenu;
import com.mongenscave.mcspotifylink.gui.models.TracksMenu;
import com.mongenscave.mcspotifylink.identifiers.keys.ItemKeys;
import com.mongenscave.mcspotifylink.identifiers.keys.MenuKeys;
import com.mongenscave.mcspotifylink.item.ItemFactory;
import com.mongenscave.mcspotifylink.manager.SpotifyManager;
import com.mongenscave.mcspotifylink.processor.MessageProcessor;
import com.mongenscave.mcspotifylink.utils.LoggerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PlayListsMenu
extends PaginatedMenu {
    private final ConcurrentHashMap<Integer, ItemKeys> slotToItemKeyMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Playlist> slotToPlaylistMap = new ConcurrentHashMap();
    private List<Playlist> playlists;
    private List<Integer> availableSlots;

    public PlayListsMenu(@NotNull MenuController menuController) {
        super(menuController);
        this.loadPlaylists();
    }

    private void loadPlaylists() {
        Player player = this.menuController.owner();
        McSpotifyLink plugin = McSpotifyLink.getInstance();
        SpotifyManager spotifyManager = plugin.getSpotifyManager();
        spotifyManager.getUserPlaylists(player).whenComplete((playlists, exception) -> {
            if (exception != null) {
                LoggerUtils.error(exception.getMessage(), new Object[0]);
                return;
            }
            this.playlists = playlists;
            plugin.getScheduler().runTask(() -> {
                if (this.inventory != null) {
                    this.setMenuItems();
                }
            });
        });
    }

    @Override
    public void handleMenu(@NotNull InventoryClickEvent event) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        int slot = event.getSlot();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        ItemKeys clickedItemKey = this.slotToItemKeyMap.get(slot);
        if (clickedItemKey != null) {
            switch (clickedItemKey) {
                case PLAYLIST_BACK: {
                    if (this.page > 0) {
                        --this.page;
                        this.setMenuItems();
                        break;
                    }
                    new NavigationMenu(this.menuController).open();
                    break;
                }
                case PLAYLIST_FORWARD: {
                    if (!this.hasNextPage()) break;
                    ++this.page;
                    this.setMenuItems();
                }
            }
        } else {
            Playlist playlist = this.slotToPlaylistMap.get(slot);
            if (playlist != null) {
                TracksMenu tracksMenu = new TracksMenu(this.menuController, playlist);
                tracksMenu.open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        this.slotToItemKeyMap.clear();
        this.slotToPlaylistMap.clear();
        ItemFactory.setItemsForMenu("playlist-menu.items", this.inventory);
        this.setMenuItem(ItemKeys.PLAYLIST_BACK);
        this.setMenuItem(ItemKeys.PLAYLIST_FORWARD);
        this.findAvailableSlots();
        if (this.playlists != null && !this.availableSlots.isEmpty()) {
            this.populatePlaylistItems();
        }
    }

    private void findAvailableSlots() {
        this.availableSlots = new ArrayList<Integer>();
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.availableSlots.add(i);
        }
    }

    private void populatePlaylistItems() {
        int playlistsPerPage = this.availableSlots.size();
        int startIndex = this.page * playlistsPerPage;
        int endIndex = Math.min(startIndex + playlistsPerPage, this.playlists.size());
        for (int i = startIndex; i < endIndex; ++i) {
            Playlist playlist = this.playlists.get(i);
            int slotIndex = i - startIndex;
            if (slotIndex >= this.availableSlots.size()) break;
            int slot = this.availableSlots.get(slotIndex);
            ItemStack playlistItem = this.createPlaylistItem(playlist);
            this.inventory.setItem(slot, playlistItem);
            this.slotToPlaylistMap.put(slot, playlist);
        }
    }

    private ItemStack createPlaylistItem(@NotNull Playlist playlist) {
        try {
            Material material;
            McSpotifyLink plugin = McSpotifyLink.getInstance();
            String nameTemplate = plugin.getConfiguration().getString("gui.playlist-item.name", "&#39fc03{name} &8- &8(&#39fc03{count}&8)");
            String processedName = MessageProcessor.process(nameTemplate.replace("{name}", playlist.name()).replace("{count}", String.valueOf(playlist.totalTracks())));
            List<String> loreTemplate = plugin.getConfiguration().getStringList("gui.playlist-item.lore");
            if (loreTemplate == null || loreTemplate.isEmpty()) {
                loreTemplate = List.of("", " &8&l| &7\u1d04\u029f\u026a\u1d04\u1d0b &8\u00bb &f\u1d0f\u1d18\u1d07\u0274", "");
            }
            List<String> lore = loreTemplate.stream().map(MessageProcessor::process).toList();
            String materialName = plugin.getConfiguration().getString("gui.playlist-item.material", "JUKEBOX");
            try {
                material = Material.valueOf((String)materialName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                material = Material.JUKEBOX;
                LoggerUtils.error("Invalid material '" + materialName + "' for playlist item, using JUKEBOX", new Object[0]);
            }
            return ItemFactory.create(material).setName(processedName).addLore(lore.toArray(new String[0])).finish();
        }
        catch (Exception exception) {
            LoggerUtils.error("Failed to create playlist item: " + exception.getMessage(), new Object[0]);
            return ItemFactory.create(Material.JUKEBOX).setName("\u00a7cError: " + playlist.name()).addLore("\u00a77Tracks: " + playlist.totalTracks()).finish();
        }
    }

    private boolean hasNextPage() {
        if (this.playlists == null || this.availableSlots == null || this.availableSlots.isEmpty()) {
            return false;
        }
        int playlistsPerPage = this.availableSlots.size();
        return (this.page + 1) * playlistsPerPage < this.playlists.size();
    }

    @Override
    public String getMenuName() {
        return MenuKeys.MENU_PLAYLIST_TITLE.getString();
    }

    @Override
    public int getSlots() {
        return MenuKeys.MENU_PLAYLIST_SIZE.getInt();
    }

    @Override
    public int getMenuTick() {
        return 20;
    }

    private void setMenuItem(@NotNull ItemKeys itemKey) {
        ItemStack item = itemKey.getItem();
        if (item == null) {
            return;
        }
        int slot = itemKey.getSlot();
        this.inventory.setItem(slot, item);
        this.slotToItemKeyMap.put(slot, itemKey);
    }
}

