/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcspotifylink.gui.models;

import com.mongenscave.mcspotifylink.McSpotifyLink;
import com.mongenscave.mcspotifylink.data.common.MenuController;
import com.mongenscave.mcspotifylink.data.spotify.Playlist;
import com.mongenscave.mcspotifylink.data.spotify.Track;
import com.mongenscave.mcspotifylink.gui.PaginatedMenu;
import com.mongenscave.mcspotifylink.gui.models.PlayListsMenu;
import com.mongenscave.mcspotifylink.identifiers.keys.ItemKeys;
import com.mongenscave.mcspotifylink.identifiers.keys.MenuKeys;
import com.mongenscave.mcspotifylink.item.ItemFactory;
import com.mongenscave.mcspotifylink.manager.SpotifyManager;
import com.mongenscave.mcspotifylink.processor.MessageProcessor;
import com.mongenscave.mcspotifylink.utils.LoggerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TracksMenu
extends PaginatedMenu {
    private final ConcurrentHashMap<Integer, ItemKeys> slotToItemKeyMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, String> slotToTrackUriMap = new ConcurrentHashMap();
    private final Playlist playlist;
    private List<Track> tracks;
    private List<Integer> availableSlots;

    public TracksMenu(@NotNull MenuController menuController, @NotNull Playlist playlist) {
        super(menuController);
        this.playlist = playlist;
        this.loadTracks();
    }

    private void loadTracks() {
        Player player = this.menuController.owner();
        McSpotifyLink plugin = McSpotifyLink.getInstance();
        SpotifyManager spotifyManager = plugin.getSpotifyManager();
        spotifyManager.getPlaylistTracks(player, this.playlist.id()).whenComplete((tracks, exception) -> {
            if (exception != null) {
                LoggerUtils.error(exception.getMessage(), new Object[0]);
                return;
            }
            this.tracks = tracks;
            plugin.getScheduler().runTask(() -> {
                if (this.inventory != null) {
                    this.setMenuItems();
                }
            });
        });
    }

    @Override
    public void handleMenu(@NotNull InventoryClickEvent event) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        int slot = event.getSlot();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        ItemKeys clickedItemKey = this.slotToItemKeyMap.get(slot);
        if (clickedItemKey != null) {
            switch (clickedItemKey) {
                case TRACKS_BACK: {
                    if (this.page > 0) {
                        --this.page;
                        this.setMenuItems();
                        break;
                    }
                    new PlayListsMenu(this.menuController).open();
                    break;
                }
                case TRACKS_FORWARD: {
                    if (!this.hasNextPage()) break;
                    ++this.page;
                    this.setMenuItems();
                }
            }
        } else {
            String trackUri = this.slotToTrackUriMap.get(slot);
            McSpotifyLink plugin = McSpotifyLink.getInstance();
            if (trackUri != null) {
                Player player = (Player)event.getWhoClicked();
                plugin.getSpotifyManager().playTrack(player, trackUri).exceptionally(exception -> {
                    LoggerUtils.error(exception.getMessage(), new Object[0]);
                    return null;
                });
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        this.slotToItemKeyMap.clear();
        this.slotToTrackUriMap.clear();
        ItemFactory.setItemsForMenu("tracks-menu.items", this.inventory);
        this.setMenuItem(ItemKeys.TRACKS_BACK);
        this.setMenuItem(ItemKeys.TRACKS_FORWARD);
        this.findAvailableSlots();
        if (this.tracks != null && !this.availableSlots.isEmpty()) {
            this.populateTrackItems();
        }
    }

    private void findAvailableSlots() {
        this.availableSlots = new ArrayList<Integer>();
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.availableSlots.add(i);
        }
    }

    private void populateTrackItems() {
        int tracksPerPage = this.availableSlots.size();
        int startIndex = this.page * tracksPerPage;
        int endIndex = Math.min(startIndex + tracksPerPage, this.tracks.size());
        for (int i = startIndex; i < endIndex; ++i) {
            Track track = this.tracks.get(i);
            int slotIndex = i - startIndex;
            if (slotIndex >= this.availableSlots.size()) break;
            int slot = this.availableSlots.get(slotIndex);
            ItemStack trackItem = this.createTrackItem(track);
            this.inventory.setItem(slot, trackItem);
            this.slotToTrackUriMap.put(slot, track.uri());
        }
    }

    private ItemStack createTrackItem(@NotNull Track track) {
        Material material;
        McSpotifyLink plugin = McSpotifyLink.getInstance();
        String nameTemplate = plugin.getConfiguration().getString("gui.track-item.name");
        String processedName = MessageProcessor.process(nameTemplate.replace("{name}", track.name()).replace("{author}", track.artist()));
        List<String> loreTemplate = plugin.getConfiguration().getStringList("gui.track-item.lore");
        List<String> lore = loreTemplate.stream().map(line -> MessageProcessor.process(line.replace("{length}", track.getFormattedDuration()))).toList();
        String materialName = plugin.getConfiguration().getString("gui.track-item.material");
        try {
            material = Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            material = Material.MUSIC_DISC_CAT;
        }
        return ItemFactory.create(material).setName(processedName).addLore(lore.toArray(new String[0])).finish();
    }

    private boolean hasNextPage() {
        if (this.tracks == null || this.availableSlots == null || this.availableSlots.isEmpty()) {
            return false;
        }
        int tracksPerPage = this.availableSlots.size();
        return (this.page + 1) * tracksPerPage < this.tracks.size();
    }

    @Override
    public String getMenuName() {
        return MenuKeys.MENU_TRACKS_TITLE.getString().replace("{playlist}", this.playlist.name());
    }

    @Override
    public int getSlots() {
        return MenuKeys.MENU_TRACKS_SIZE.getInt();
    }

    @Override
    public int getMenuTick() {
        return 20;
    }

    private void setMenuItem(@NotNull ItemKeys itemKey) {
        ItemStack item = itemKey.getItem();
        if (item == null) {
            return;
        }
        int slot = itemKey.getSlot();
        this.inventory.setItem(slot, item);
        this.slotToItemKeyMap.put(slot, itemKey);
    }
}

