/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcspotifylink.identifiers.keys;

import com.mongenscave.mcspotifylink.McSpotifyLink;
import com.mongenscave.mcspotifylink.config.Config;
import com.mongenscave.mcspotifylink.processor.MessageProcessor;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public enum MessageKeys {
    NO_PERMISSION("messages.no-permission"),
    PLAYER_REQUIRED("messages.player-required"),
    RELOAD("messages.reload"),
    HELP("messages.help"),
    ALREADY_CONNECTED("messages.already-connected"),
    CONNECT("messages.connect"),
    NOT_CONNECTED("messages.not-connected"),
    DISCONNECTED("messages.disconnected"),
    CURRENT_LISTENING("messages.current-listening"),
    NOT_LISTENING("messages.not-listening"),
    CONTROL("messages.control"),
    CONNECTED("messages.connected"),
    ERROR("messages.error");

    private static final Config language;
    private final String path;

    private MessageKeys(String path) {
        this.path = path;
    }

    @NotNull
    public String getMessage() {
        return MessageProcessor.process(language.getString(this.path)).replace("%prefix%", MessageProcessor.process(language.getString("prefix")));
    }

    public List<String> getMessages() {
        return language.getStringList(this.path).stream().toList();
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    static {
        language = McSpotifyLink.getInstance().getLanguage();
    }
}

