/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcspotifylink.item;

import com.mongenscave.mcspotifylink.McSpotifyLink;
import com.mongenscave.mcspotifylink.boostedyaml.block.implementation.Section;
import com.mongenscave.mcspotifylink.config.Config;
import com.mongenscave.mcspotifylink.data.common.ItemData;
import com.mongenscave.mcspotifylink.item.ItemBuilder;
import com.mongenscave.mcspotifylink.processor.MessageProcessor;
import com.mongenscave.mcspotifylink.utils.LoggerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public interface ItemFactory {
    @Contract(value="_ -> new")
    @NotNull
    public static ItemFactory create(@NotNull Material material) {
        return new ItemBuilder(material);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static ItemFactory create(@NotNull Material material, int count) {
        return new ItemBuilder(material, count);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static ItemFactory create(@NotNull Material material, int count, short damage) {
        return new ItemBuilder(material, count, damage);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ItemFactory create(ItemStack item) {
        return new ItemBuilder(item);
    }

    public static Optional<ItemStack> buildItem(@NotNull Section section, @NotNull String configPath) {
        try {
            Material material;
            String materialName = section.getString("material");
            if (materialName == null || materialName.isEmpty()) {
                return Optional.empty();
            }
            try {
                material = Material.valueOf((String)materialName.toUpperCase());
            }
            catch (IllegalArgumentException exception) {
                return Optional.empty();
            }
            int amount = section.getInt("amount", Integer.valueOf(1));
            amount = Math.max(1, Math.min(amount, 64));
            String rawName = section.getString("name", "");
            String processedName = rawName.isEmpty() ? "" : MessageProcessor.process(rawName);
            List<String> lore = section.getStringList("lore").stream().map(MessageProcessor::process).toList();
            List<ItemFlag> flags = section.getStringList("flag").stream().map(ItemFlag::valueOf).toList();
            ItemStack item = ItemFactory.create(material, amount).setName(processedName).addLore(lore.toArray(new String[0])).finish();
            List enchantmentStrings = section.getStringList("enchantments");
            for (String enchantmentString : enchantmentStrings) {
                String[] parts = enchantmentString.split(":");
                if (parts.length != 2) continue;
                try {
                    Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)parts[0].toLowerCase()));
                    if (enchantment == null) continue;
                    int level = Integer.parseInt(parts[1]);
                    item.addUnsafeEnchantment(enchantment, level);
                }
                catch (Exception exception) {}
            }
            boolean unbreakable = section.getBoolean("unbreakable", Boolean.valueOf(false));
            if (unbreakable) {
                item.editMeta(meta -> meta.setUnbreakable(true));
            }
            item.editMeta(meta -> {
                PersistentDataContainer pdc = meta.getPersistentDataContainer();
                NamespacedKey key = new NamespacedKey((Plugin)McSpotifyLink.getInstance(), "mcSpotifyLink");
                pdc.set(key, PersistentDataType.STRING, (Object)configPath);
                meta.addItemFlags(flags.toArray(new ItemFlag[0]));
            });
            return Optional.of(item);
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static Optional<ItemStack> createItemFromString(@NotNull String path, @NotNull Config config) {
        Section section = config.getSection(path);
        return section != null ? ItemFactory.buildItem(section, path) : Optional.empty();
    }

    public ItemFactory setType(@NotNull Material var1);

    public ItemFactory setCount(int var1);

    public ItemFactory setName(@NotNull String var1);

    public ItemBuilder setLore(@NotNull List<String> var1);

    public void addEnchantment(@NotNull Enchantment var1, int var2);

    default public ItemFactory addEnchantments(@NotNull ConcurrentHashMap<Enchantment, Integer> enchantments) {
        enchantments.forEach(this::addEnchantment);
        return this;
    }

    public ItemBuilder addLore(String ... var1);

    public ItemFactory setUnbreakable();

    default public void addFlag(ItemFlag ... flags) {
        Arrays.stream(flags).forEach(xva$0 -> this.addFlag((ItemFlag)xva$0));
    }

    public ItemFactory removeLore(int var1);

    public ItemStack finish();

    public boolean isFinished();

    public static void setItemsForMenu(@NotNull String path, @NotNull Inventory inventory) {
        try {
            Config config = McSpotifyLink.getInstance().getGuis();
            Section section = config.getSection(path);
            if (section == null) {
                LoggerUtils.warn("No section found at path: " + path, new Object[0]);
                return;
            }
            ConcurrentHashMap<String, ItemData> itemsToPlace = new ConcurrentHashMap<String, ItemData>();
            for (String key : section.getRoutesAsStrings(false)) {
                Section itemSection = section.getSection(key);
                if (itemSection == null) continue;
                String fullPath = path + "." + key;
                Optional<ItemStack> itemOptional = ItemFactory.buildItem(itemSection, fullPath);
                if (itemOptional.isPresent()) {
                    Object slotConfig = itemSection.get("slot");
                    List<Integer> slots = ItemFactory.parseSmartSlots(slotConfig, inventory);
                    if (slots.isEmpty()) continue;
                    itemsToPlace.put(key, new ItemData(itemOptional.get(), slots, itemSection.getInt("priority", Integer.valueOf(0))));
                    continue;
                }
                LoggerUtils.warn("Failed to build item from path: " + fullPath, new Object[0]);
            }
            itemsToPlace.entrySet().stream().sorted((e1, e2) -> Integer.compare(((ItemData)e2.getValue()).priority(), ((ItemData)e1.getValue()).priority())).forEach(entry -> ItemFactory.placeItemInSlots((ItemData)entry.getValue(), inventory));
        }
        catch (Exception exception) {
            LoggerUtils.error("Failed to set items for menu from path " + path + ": " + exception.getMessage(), new Object[0]);
        }
    }

    private static List<Integer> parseSmartSlots(Object slotConfig, Inventory inventory) {
        if (slotConfig == null) {
            return Collections.emptyList();
        }
        int size = inventory.getSize();
        if (slotConfig instanceof Integer) {
            int slot = (Integer)slotConfig;
            return ItemFactory.isValidSlot(slot, size) ? List.of(Integer.valueOf(slot)) : Collections.emptyList();
        }
        if (slotConfig instanceof String) {
            String slotStr;
            switch (slotStr = ((String)slotConfig).toLowerCase().trim()) {
                case "border": {
                    return ItemFactory.getBorderSlots(size);
                }
                case "corners": {
                    return ItemFactory.getCornerSlots(size);
                }
                case "center": {
                    return ItemFactory.getCenterSlots(size);
                }
                case "edges": {
                    return ItemFactory.getEdgeSlots(size);
                }
                case "top": {
                    return ItemFactory.getTopRowSlots();
                }
                case "bottom": {
                    return ItemFactory.getBottomRowSlots(size);
                }
                case "left": {
                    return ItemFactory.getLeftColumnSlots(size);
                }
                case "right": {
                    return ItemFactory.getRightColumnSlots(size);
                }
                case "fill": {
                    return ItemFactory.getFillSlots(inventory);
                }
            }
            if (slotStr.startsWith("grid:")) {
                return ItemFactory.parseGridSlots(slotStr, size);
            }
            if (slotStr.startsWith("chess:")) {
                return ItemFactory.parseChessSlots(slotStr, size);
            }
            return ItemFactory.parseCustomSlots(slotStr, size);
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<Integer> parseCustomSlots(@NotNull String slotStr, int size) {
        String[] parts;
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (String part : parts = slotStr.split(",")) {
            if ((part = part.trim()).contains("-")) {
                String[] range = part.split("-");
                if (range.length != 2) continue;
                try {
                    int start = Integer.parseInt(range[0].trim());
                    int end = Integer.parseInt(range[1].trim());
                    for (int i = Math.min(start, end); i <= Math.max(start, end); ++i) {
                        if (!ItemFactory.isValidSlot(i, size)) continue;
                        slots.add(i);
                    }
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            try {
                int slot = Integer.parseInt(part);
                if (!ItemFactory.isValidSlot(slot, size)) continue;
                slots.add(slot);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return slots;
    }

    private static List<Integer> parseGridSlots(@NotNull String gridStr, int size) {
        String[] parts = gridStr.split(":");
        if (parts.length < 2) {
            return Collections.emptyList();
        }
        String[] dimensions = parts[1].split("x");
        if (dimensions.length != 2) {
            return Collections.emptyList();
        }
        try {
            return ItemFactory.getIntegers(size, dimensions, parts);
        }
        catch (NumberFormatException exception) {
            return Collections.emptyList();
        }
    }

    @NotNull
    private static List<Integer> getIntegers(int size, @NotNull String[] dimensions, @NotNull String[] parts) {
        int cols = Integer.parseInt(dimensions[0]);
        int rows = Integer.parseInt(dimensions[1]);
        int offset = parts.length > 3 ? Integer.parseInt(parts[3]) : 0;
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int slot = offset + row * 9 + col;
                if (!ItemFactory.isValidSlot(slot, size)) continue;
                slots.add(slot);
            }
        }
        return slots;
    }

    @NotNull
    private static List<Integer> parseChessSlots(@NotNull String chessStr, int size) {
        String[] parts = chessStr.split(":");
        if (parts.length < 2) {
            return Collections.emptyList();
        }
        boolean isBlack = parts[1].equals("black");
        List<Integer> slots = Collections.synchronizedList(new ArrayList());
        int rows = size / 9;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < 9; ++col) {
                boolean isBlackSquare;
                int slot = row * 9 + col;
                boolean bl = isBlackSquare = (row + col) % 2 == 0;
                if (isBlack != isBlackSquare || !ItemFactory.isValidSlot(slot, size)) continue;
                slots.add(slot);
            }
        }
        return slots;
    }

    private static List<Integer> getBorderSlots(int size) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int rows = size / 9;
        for (int i = 0; i < 9; ++i) {
            slots.add(i);
            if (rows <= 1) continue;
            slots.add((rows - 1) * 9 + i);
        }
        for (int row = 1; row < rows - 1; ++row) {
            slots.add(row * 9);
            slots.add(row * 9 + 8);
        }
        return slots.stream().distinct().sorted().toList();
    }

    @NotNull
    private static List<Integer> getCornerSlots(int size) {
        int rows = size / 9;
        ArrayList<Integer> corners = new ArrayList<Integer>();
        corners.add(0);
        corners.add(8);
        if (rows > 1) {
            corners.add((rows - 1) * 9);
            corners.add((rows - 1) * 9 + 8);
        }
        return corners;
    }

    @NotNull
    private static List<Integer> getCenterSlots(int size) {
        int rows = size / 9;
        ArrayList<Integer> centers = new ArrayList<Integer>();
        if (rows >= 3) {
            int centerRow = rows / 2;
            for (int col = 3; col <= 5; ++col) {
                centers.add(centerRow * 9 + col);
            }
        }
        return centers;
    }

    @NotNull
    private static List<Integer> getEdgeSlots(int size) {
        ArrayList<Integer> edges = new ArrayList<Integer>();
        int rows = size / 9;
        for (int row = 1; row < rows - 1; ++row) {
            for (int col = 1; col < 8; ++col) {
                edges.add(row * 9 + col);
            }
        }
        return edges;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    private static @Unmodifiable List<Integer> getTopRowSlots() {
        return List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8));
    }

    @NotNull
    private static List<Integer> getBottomRowSlots(int size) {
        int lastRow = size / 9 - 1;
        List<Integer> slots = Collections.synchronizedList(new ArrayList());
        for (int i = 0; i < 9; ++i) {
            slots.add(lastRow * 9 + i);
        }
        return slots;
    }

    @NotNull
    private static List<Integer> getLeftColumnSlots(int size) {
        List<Integer> slots = Collections.synchronizedList(new ArrayList());
        int rows = size / 9;
        for (int row = 0; row < rows; ++row) {
            slots.add(row * 9);
        }
        return slots;
    }

    @NotNull
    private static List<Integer> getRightColumnSlots(int size) {
        List<Integer> slots = Collections.synchronizedList(new ArrayList());
        int rows = size / 9;
        for (int row = 0; row < rows; ++row) {
            slots.add(row * 9 + 8);
        }
        return slots;
    }

    @NotNull
    private static List<Integer> getFillSlots(@NotNull Inventory inventory) {
        List<Integer> emptySlots = Collections.synchronizedList(new ArrayList());
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null) continue;
            emptySlots.add(i);
        }
        return emptySlots;
    }

    private static boolean isValidSlot(int slot, int size) {
        return slot >= 0 && slot < size;
    }

    private static void placeItemInSlots(@NotNull ItemData itemData, Inventory inventory) {
        for (int slot : itemData.slots()) {
            if (slot < 0 || slot >= inventory.getSize()) continue;
            inventory.setItem(slot, itemData.item().clone());
        }
    }
}

