/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcspotifylink.manager;

import com.mongenscave.mcspotifylink.McSpotifyLink;
import com.mongenscave.mcspotifylink.data.spotify.Playlist;
import com.mongenscave.mcspotifylink.data.spotify.SpotifyUser;
import com.mongenscave.mcspotifylink.data.spotify.Track;
import com.mongenscave.mcspotifylink.gson.Gson;
import com.mongenscave.mcspotifylink.gson.JsonArray;
import com.mongenscave.mcspotifylink.gson.JsonElement;
import com.mongenscave.mcspotifylink.gson.JsonObject;
import com.mongenscave.mcspotifylink.http.HttpEntity;
import com.mongenscave.mcspotifylink.http.client.methods.CloseableHttpResponse;
import com.mongenscave.mcspotifylink.http.client.methods.HttpGet;
import com.mongenscave.mcspotifylink.http.client.methods.HttpPost;
import com.mongenscave.mcspotifylink.http.client.methods.HttpPut;
import com.mongenscave.mcspotifylink.http.client.methods.HttpUriRequest;
import com.mongenscave.mcspotifylink.http.entity.StringEntity;
import com.mongenscave.mcspotifylink.http.impl.client.CloseableHttpClient;
import com.mongenscave.mcspotifylink.http.impl.client.HttpClients;
import com.mongenscave.mcspotifylink.http.util.EntityUtils;
import com.mongenscave.mcspotifylink.identifiers.keys.ConfigKeys;
import com.mongenscave.mcspotifylink.interfaces.HttpRequestFactory;
import com.mongenscave.mcspotifylink.model.CurrentTrack;
import com.mongenscave.mcspotifylink.processor.MessageProcessor;
import com.mongenscave.mcspotifylink.utils.LoggerUtils;
import com.mongenscave.mcspotifylink.utils.PlayerUtils;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpotifyManager {
    private static final McSpotifyLink plugin = McSpotifyLink.getInstance();
    private final Gson gson = new Gson();
    private final CloseableHttpClient httpClient = HttpClients.createDefault();
    private final ConcurrentHashMap<UUID, SpotifyUser> connectedUsers = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, CurrentTrack> currentTracks = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, String> lastTrackIds = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, Long> lastUpdateTime = new ConcurrentHashMap();

    public SpotifyManager() {
        this.loadConnectedUsers();
        this.startContinuousUpdates();
    }

    private void startContinuousUpdates() {
        plugin.getScheduler().runTaskTimerAsynchronously(() -> {
            List<CompletableFuture<Void>> updateFutures = Collections.synchronizedList(new ArrayList());
            for (UUID playerId : this.connectedUsers.keySet()) {
                Player player = plugin.getServer().getPlayer(playerId);
                if (player == null || !player.isOnline()) continue;
                CompletableFuture<Void> updateFuture = this.updatePlayerInternal(player);
                updateFutures.add(updateFuture);
            }
            CompletableFuture.allOf(updateFutures.toArray(new CompletableFuture[0])).exceptionally(throwable -> {
                LoggerUtils.error("Error during batch player updates: " + throwable.getMessage(), new Object[0]);
                return null;
            });
        }, 20L, 10L);
    }

    public String getAuthorizationUrl(@NotNull Player player) {
        String clientId = ConfigKeys.SPOTIFY_CLIENT_ID.getString();
        String redirectUri = ConfigKeys.SPOTIFY_REDIRECT_URI.getString();
        String state = player.getUniqueId().toString();
        String scopes = String.join((CharSequence)"%20", ConfigKeys.SPOTIFY_SCOPES.getList());
        return "https://accounts.spotify.com/authorize?response_type=code&client_id=" + clientId + "&scope=" + scopes + "&redirect_uri=" + URLEncoder.encode(redirectUri, StandardCharsets.UTF_8) + "&state=" + state + "&show_dialog=true";
    }

    public CompletableFuture<Boolean> connectUser(@NotNull Player player, @NotNull String authCode) {
        return ((CompletableFuture)this.exchangeCodeForToken(authCode).thenCompose(accessToken -> {
            if (accessToken != null) {
                SpotifyUser user = new SpotifyUser(player.getUniqueId(), (String)accessToken);
                this.connectedUsers.put(player.getUniqueId(), user);
                return ((CompletableFuture)plugin.getDatabase().saveUser(user).thenCompose(v -> this.updatePlayerInternal(player))).thenApply(v -> true);
            }
            return CompletableFuture.completedFuture(false);
        })).exceptionally(throwable -> {
            LoggerUtils.error("Error connecting user: " + throwable.getMessage(), new Object[0]);
            return false;
        });
    }

    @NotNull
    @Contract(value="_ -> new")
    private CompletableFuture<String> exchangeCodeForToken(@NotNull String code) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String clientId = ConfigKeys.SPOTIFY_CLIENT_ID.getString();
                String clientSecret = ConfigKeys.SPOTIFY_CLIENT_SECRET.getString();
                String redirectUri = ConfigKeys.SPOTIFY_REDIRECT_URI.getString();
                HttpPost post = new HttpPost("https://accounts.spotify.com/api/token");
                post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                String auth = clientId + ":" + clientSecret;
                String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
                post.setHeader("Authorization", "Basic " + encodedAuth);
                String body = String.format("grant_type=authorization_code&code=%s&redirect_uri=%s", code, URLEncoder.encode(redirectUri, StandardCharsets.UTF_8));
                post.setEntity((HttpEntity)new StringEntity(body));
                try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
                    String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                    JsonObject json = (JsonObject)this.gson.fromJson(responseBody, JsonObject.class);
                    if (!json.has("access_token")) return null;
                    String string = json.get("access_token").getAsString();
                    return string;
                }
            }
            catch (Exception exception) {
                LoggerUtils.error(exception.getMessage(), new Object[0]);
            }
            return null;
        });
    }

    public CompletableFuture<Void> updatePlayer(@NotNull Player player) {
        return this.updatePlayerInternal(player);
    }

    private CompletableFuture<Void> updatePlayerInternal(@NotNull Player player) {
        SpotifyUser user = this.connectedUsers.get(player.getUniqueId());
        if (user == null) {
            return CompletableFuture.completedFuture(null);
        }
        long currentTime = System.currentTimeMillis();
        Long lastUpdate = this.lastUpdateTime.get(player.getUniqueId());
        if (lastUpdate != null && currentTime - lastUpdate < 1000L) {
            return CompletableFuture.completedFuture(null);
        }
        this.lastUpdateTime.put(player.getUniqueId(), currentTime);
        return ((CompletableFuture)this.getCurrentTrack(user.accessToken()).thenAccept(track -> this.handleTrackUpdate(player, (CurrentTrack)track))).exceptionally(throwable -> null);
    }

    private void handleTrackUpdate(@NotNull Player player, @Nullable CurrentTrack track) {
        UUID playerId = player.getUniqueId();
        if (track != null) {
            String lastTrackId;
            boolean isNewTrack;
            String currentTrackId = track.getTrackName() + ":" + track.getArtistName();
            boolean bl = isNewTrack = !currentTrackId.equals(lastTrackId = this.lastTrackIds.get(playerId));
            if (isNewTrack) {
                if (ConfigKeys.TOAST_ENABLED.getBoolean()) {
                    PlayerUtils.sendToast(player, MessageProcessor.process(ConfigKeys.TOAST_MESSAGE.getString().replace("{name}", track.getTrackName()).replace("{author}", track.getArtistName())), "", Material.valueOf((String)ConfigKeys.TOAST_MATERIAL.getString()));
                }
                this.lastTrackIds.put(playerId, currentTrackId);
            }
            this.currentTracks.put(playerId, track);
            if (plugin.getTimestampManager() != null) {
                plugin.getTimestampManager().startTimestampUpdates();
            }
        } else {
            CurrentTrack lastTrack = this.currentTracks.get(playerId);
            if (lastTrack != null) {
                CurrentTrack stoppedTrack = new CurrentTrack(lastTrack.getTrackName(), lastTrack.getArtistName(), lastTrack.getDurationMs(), lastTrack.getProgressMs(), false);
                this.currentTracks.put(playerId, stoppedTrack);
            }
        }
    }

    @NotNull
    @Contract(value="_ -> new")
    private CompletableFuture<CurrentTrack> getCurrentTrack(@NotNull String accessToken) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                HttpGet get = new HttpGet("https://api.spotify.com/v1/me/player/currently-playing");
                get.setHeader("Authorization", "Bearer " + accessToken);
                try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
                    if (response.getStatusLine().getStatusCode() != 200) return null;
                    String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                    JsonObject json = (JsonObject)this.gson.fromJson(responseBody, JsonObject.class);
                    if (!json.has("item")) return null;
                    JsonObject item = json.getAsJsonObject("item");
                    String trackName = item.get("name").getAsString();
                    String artistName = item.getAsJsonArray("artists").get(0).getAsJsonObject().get("name").getAsString();
                    long durationMs = item.get("duration_ms").getAsLong();
                    long progressMs = json.has("progress_ms") ? json.get("progress_ms").getAsLong() : 0L;
                    boolean isPlaying = json.has("is_playing") && json.get("is_playing").getAsBoolean();
                    CurrentTrack currentTrack = new CurrentTrack(trackName, artistName, durationMs, progressMs, isPlaying);
                    return currentTrack;
                }
            }
            catch (Exception exception) {
                LoggerUtils.error(exception.getMessage(), new Object[0]);
            }
            return null;
        });
    }

    public CompletableFuture<Void> previousTrack(@NotNull Player player) {
        return this.executePlayerAction(player, "https://api.spotify.com/v1/me/player/previous", HttpPost::new);
    }

    public CompletableFuture<Void> nextTrack(@NotNull Player player) {
        return this.executePlayerAction(player, "https://api.spotify.com/v1/me/player/next", HttpPost::new);
    }

    public CompletableFuture<Void> pausePlayback(@NotNull Player player) {
        return this.executePlayerAction(player, "https://api.spotify.com/v1/me/player/pause", HttpPut::new);
    }

    public CompletableFuture<Void> resumePlayback(@NotNull Player player) {
        return this.executePlayerAction(player, "https://api.spotify.com/v1/me/player/play", HttpPut::new);
    }

    private CompletableFuture<Void> executePlayerAction(@NotNull Player player, @NotNull String url, @NotNull HttpRequestFactory requestFactory) {
        SpotifyUser user = this.connectedUsers.get(player.getUniqueId());
        if (user == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)CompletableFuture.runAsync(() -> {
            try {
                HttpUriRequest request = requestFactory.create(url);
                request.setHeader("Authorization", "Bearer " + user.accessToken());
                try (CloseableHttpResponse response = this.httpClient.execute(request);){
                    response.getStatusLine().getStatusCode();
                }
            }
            catch (Exception exception) {
                LoggerUtils.error(exception.getMessage(), new Object[0]);
            }
        }).thenCompose(v -> CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
            }
        }).thenCompose(ignored -> this.updatePlayerInternal(player)))).exceptionally(throwable -> {
            LoggerUtils.error("Error executing player action: " + throwable.getMessage(), new Object[0]);
            return null;
        });
    }

    public CompletableFuture<List<Playlist>> getUserPlaylists(@NotNull Player player) {
        SpotifyUser user = this.connectedUsers.get(player.getUniqueId());
        if (user == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                HttpGet get = new HttpGet("https://api.spotify.com/v1/me/playlists?limit=50");
                get.setHeader("Authorization", "Bearer " + user.accessToken());
                try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
                    if (response.getStatusLine().getStatusCode() != 200) return Collections.emptyList();
                    String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                    JsonObject json = (JsonObject)this.gson.fromJson(responseBody, JsonObject.class);
                    List<Playlist> playlists = Collections.synchronizedList(new ArrayList());
                    if (json.has("items")) {
                        for (JsonElement item : json.getAsJsonArray("items")) {
                            JsonObject playlistObj = item.getAsJsonObject();
                            String id = playlistObj.get("id").getAsString();
                            String name = playlistObj.get("name").getAsString();
                            int totalTracks = playlistObj.getAsJsonObject("tracks").get("total").getAsInt();
                            playlists.add(new Playlist(id, name, totalTracks));
                        }
                    }
                    List<Playlist> list = playlists;
                    return list;
                }
            }
            catch (Exception exception) {
                LoggerUtils.error(exception.getMessage(), new Object[0]);
            }
            return Collections.emptyList();
        }).exceptionally(throwable -> {
            LoggerUtils.error("Failed to get user playlists: " + throwable.getMessage(), new Object[0]);
            return Collections.emptyList();
        });
    }

    public CompletableFuture<List<Track>> getPlaylistTracks(@NotNull Player player, @NotNull String playlistId) {
        SpotifyUser user = this.connectedUsers.get(player.getUniqueId());
        if (user == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                HttpGet get = new HttpGet("https://api.spotify.com/v1/playlists/" + playlistId + "/tracks?limit=50");
                get.setHeader("Authorization", "Bearer " + user.accessToken());
                try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
                    if (response.getStatusLine().getStatusCode() != 200) return Collections.emptyList();
                    String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                    JsonObject json = (JsonObject)this.gson.fromJson(responseBody, JsonObject.class);
                    ArrayList<Track> tracks = new ArrayList<Track>();
                    if (json.has("items")) {
                        for (JsonElement item : json.getAsJsonArray("items")) {
                            JsonObject trackObj = item.getAsJsonObject();
                            if (!trackObj.has("track") || trackObj.get("track").isJsonNull()) continue;
                            JsonObject track = trackObj.getAsJsonObject("track");
                            String id = track.get("id").getAsString();
                            String name = track.get("name").getAsString();
                            String artist = track.getAsJsonArray("artists").get(0).getAsJsonObject().get("name").getAsString();
                            String uri = track.get("uri").getAsString();
                            long durationMs = track.get("duration_ms").getAsLong();
                            tracks.add(new Track(id, name, artist, uri, durationMs));
                        }
                    }
                    ArrayList<Track> arrayList = tracks;
                    return arrayList;
                }
            }
            catch (Exception exception) {
                LoggerUtils.error(exception.getMessage(), new Object[0]);
            }
            return Collections.emptyList();
        }).exceptionally(throwable -> {
            LoggerUtils.error("Failed to get playlist tracks: " + throwable.getMessage(), new Object[0]);
            return Collections.emptyList();
        });
    }

    public CompletableFuture<Void> playTrack(@NotNull Player player, @NotNull String trackUri) {
        SpotifyUser user = this.connectedUsers.get(player.getUniqueId());
        if (user == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)CompletableFuture.runAsync(() -> {
            try {
                HttpPut put = SpotifyManager.getHttpPut(trackUri, user);
                try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)put);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 204) {
                        LoggerUtils.warn("Failed to play track, status code: " + statusCode, new Object[0]);
                    }
                }
            }
            catch (Exception exception) {
                LoggerUtils.error(exception.getMessage(), new Object[0]);
            }
        }).thenCompose(v -> CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
            }
        }).thenCompose(ignored -> this.updatePlayerInternal(player)))).exceptionally(throwable -> null);
    }

    @NotNull
    private static HttpPut getHttpPut(@NotNull String trackUri, @NotNull SpotifyUser user) {
        HttpPut put = new HttpPut("https://api.spotify.com/v1/me/player/play");
        put.setHeader("Authorization", "Bearer " + user.accessToken());
        put.setHeader("Content-Type", "application/json");
        JsonObject requestBody = new JsonObject();
        JsonArray uris = new JsonArray();
        uris.add(trackUri);
        requestBody.add("uris", (JsonElement)uris);
        put.setEntity((HttpEntity)new StringEntity(requestBody.toString(), StandardCharsets.UTF_8));
        return put;
    }

    public CompletableFuture<Void> disconnectUser(@NotNull Player player) {
        UUID playerId = player.getUniqueId();
        this.connectedUsers.remove(playerId);
        this.currentTracks.remove(playerId);
        this.lastTrackIds.remove(playerId);
        this.lastUpdateTime.remove(playerId);
        return plugin.getDatabase().removeUser(playerId).exceptionally(throwable -> {
            LoggerUtils.error("Error removing user from database: " + throwable.getMessage(), new Object[0]);
            return null;
        });
    }

    public void removePlayer(@NotNull Player player) {
        UUID playerId = player.getUniqueId();
        this.currentTracks.remove(playerId);
        this.lastTrackIds.remove(playerId);
        this.lastUpdateTime.remove(playerId);
        if (this.currentTracks.isEmpty() && plugin.getTimestampManager() != null) {
            plugin.getTimestampManager().stopTimestampUpdates();
        }
    }

    public boolean isConnected(@NotNull Player player) {
        return this.connectedUsers.containsKey(player.getUniqueId());
    }

    public CurrentTrack getCurrentTrack(@NotNull Player player) {
        return this.currentTracks.get(player.getUniqueId());
    }

    public CompletableFuture<ConcurrentHashMap<UUID, CurrentTrack>> getAllCurrentTracks() {
        return CompletableFuture.supplyAsync(() -> new ConcurrentHashMap<UUID, CurrentTrack>(this.currentTracks));
    }

    private void loadConnectedUsers() {
        ((CompletableFuture)plugin.getDatabase().loadUsers().thenAccept(this.connectedUsers::putAll)).exceptionally(throwable -> null);
    }

    public void shutdown() {
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (Exception exception) {
            LoggerUtils.error("Error shutting down HTTP client: " + exception.getMessage(), new Object[0]);
        }
    }
}

