/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcspotifylink.manager;

import com.mongenscave.mcspotifylink.McSpotifyLink;
import com.mongenscave.mcspotifylink.identifiers.keys.ConfigKeys;
import com.mongenscave.mcspotifylink.model.CurrentTrack;
import com.mongenscave.mcspotifylink.processor.MessageProcessor;
import com.mongenscave.mcspotifylink.universalScheduler.scheduling.tasks.MyScheduledTask;
import com.mongenscave.mcspotifylink.utils.LoggerUtils;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class TimestampManager {
    private static final McSpotifyLink plugin = McSpotifyLink.getInstance();
    private MyScheduledTask timestampTask;

    public void startTimestampUpdates() {
        if (!ConfigKeys.SONGS_TIMESTAMP_ENABLED.getBoolean()) {
            return;
        }
        if (this.timestampTask != null && !this.timestampTask.isCancelled()) {
            return;
        }
        this.stopTimestampUpdates();
        this.timestampTask = plugin.getScheduler().runTaskTimerAsynchronously(this::updateAllPlayersActionBar, 0L, 20L);
    }

    public void stopTimestampUpdates() {
        if (this.timestampTask != null && !this.timestampTask.isCancelled()) {
            this.timestampTask.cancel();
            this.timestampTask = null;
        }
    }

    private void updateAllPlayersActionBar() {
        ((CompletableFuture)plugin.getSpotifyManager().getAllCurrentTracks().thenAccept(currentTracks -> {
            if (currentTracks.isEmpty()) {
                this.stopTimestampUpdates();
                return;
            }
            for (UUID playerId : currentTracks.keySet()) {
                Player player = Bukkit.getPlayer((UUID)playerId);
                if (player == null || !player.isOnline()) continue;
                this.updatePlayerActionBar(player, (CurrentTrack)currentTracks.get(playerId));
            }
        })).exceptionally(exception -> {
            LoggerUtils.error(exception.getMessage(), new Object[0]);
            return null;
        });
    }

    private void updatePlayerActionBar(@NotNull Player player, @NotNull CurrentTrack track) {
        String timestampBar = this.generateTimestampBar(track);
        String stateIndicator = track.isPlaying() ? ConfigKeys.SONGS_TIMESTAMP_PLAYING.getString() : ConfigKeys.SONGS_TIMESTAMP_PAUSE.getString();
        String actionBarMessage = ConfigKeys.SONGS_TIMESTAMP_ACTIONBAR.getString().replace("{timestamp}", timestampBar).replace("{passedLength}", track.getFormattedProgress()).replace("{remainingLength}", track.getFormattedDuration()).replace("{song}", track.getTrackName()).replace("{author}", track.getArtistName()).replace("{state}", stateIndicator);
        player.sendActionBar(MessageProcessor.process(actionBarMessage));
    }

    @NotNull
    private String generateTimestampBar(@NotNull CurrentTrack track) {
        String character = ConfigKeys.SONGS_TIMESTAMP_CHARACTER.getString();
        String passedColor = ConfigKeys.SONGS_TIMESTAMP_PASSED.getString();
        String remainingColor = ConfigKeys.SONGS_TIMESTAMP_REMAINING.getString();
        int totalLength = ConfigKeys.SONGS_TIMESTAMP_LENGTH.getInt();
        double progressPercentage = track.getProgressPercentage();
        int passedLength = (int)Math.round(progressPercentage * (double)totalLength);
        int remainingLength = totalLength - passedLength;
        return passedColor + character.repeat(Math.max(0, passedLength)) + remainingColor + character.repeat(Math.max(0, remainingLength));
    }

    @NotNull
    public String getTimestampPlaceholder(@NotNull CurrentTrack track) {
        String timestampBar = this.generateTimestampBar(track);
        String stateIndicator = track.isPlaying() ? ConfigKeys.SONGS_TIMESTAMP_PLAYING.getString() : ConfigKeys.SONGS_TIMESTAMP_PAUSE.getString();
        return ConfigKeys.SONGS_TIMESTAMP_ACTIONBAR.getString().replace("{timestamp}", timestampBar).replace("{passedLength}", track.getFormattedProgress()).replace("{remainingLength}", track.getFormattedDuration()).replace("{song}", track.getTrackName()).replace("{author}", track.getArtistName()).replace("{state}", stateIndicator);
    }
}

