/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcspotifylink.model;

import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CurrentTrack {
    private final String trackName;
    private final String artistName;
    private final long durationMs;
    private final long progressMs;
    private final long timestamp;
    private final boolean isPlaying;

    public CurrentTrack(@NotNull String trackName, @NotNull String artistName, long durationMs, long progressMs, boolean isPlaying) {
        this.trackName = trackName;
        this.artistName = artistName;
        this.durationMs = durationMs;
        this.progressMs = progressMs;
        this.timestamp = System.currentTimeMillis();
        this.isPlaying = isPlaying;
    }

    public long getCurrentProgressMs() {
        if (!this.isPlaying) {
            return this.progressMs;
        }
        long timePassed = System.currentTimeMillis() - this.timestamp;
        long currentProgress = this.progressMs + timePassed;
        return Math.min(currentProgress, this.durationMs);
    }

    public double getProgressPercentage() {
        if (this.durationMs == 0L) {
            return 0.0;
        }
        return Math.min(1.0, (double)this.getCurrentProgressMs() / (double)this.durationMs);
    }

    @NotNull
    @Contract(pure=true)
    public static String formatTime(long ms) {
        long minutes = ms / 60000L;
        long seconds = ms % 60000L / 1000L;
        return String.format("%d:%02d", minutes, seconds);
    }

    public String getFormattedProgress() {
        return CurrentTrack.formatTime(this.getCurrentProgressMs());
    }

    public String getFormattedDuration() {
        return CurrentTrack.formatTime(this.durationMs);
    }

    @Generated
    public String getTrackName() {
        return this.trackName;
    }

    @Generated
    public String getArtistName() {
        return this.artistName;
    }

    @Generated
    public long getDurationMs() {
        return this.durationMs;
    }

    @Generated
    public long getProgressMs() {
        return this.progressMs;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public boolean isPlaying() {
        return this.isPlaying;
    }
}

