/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcspotifylink.processor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MessageProcessor {
    private static final char COLOR_CHAR = '\u00a7';
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.legacySection();

    @NotNull
    public static String process(@Nullable String message) {
        if (message == null) {
            return "";
        }
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuilder builder = new StringBuilder(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(builder, "\u00a7x\u00a7" + group.charAt(0) + "\u00a7" + group.charAt(1) + "\u00a7" + group.charAt(2) + "\u00a7" + group.charAt(3) + "\u00a7" + group.charAt(4) + "\u00a7" + group.charAt(5));
        }
        String hexProcessed = matcher.appendTail(builder).toString();
        return ChatColor.translateAlternateColorCodes((char)'&', (String)hexProcessed);
    }

    @NotNull
    public static Component process(@Nullable Component message) {
        if (message == null) {
            return Component.empty();
        }
        String legacyString = LEGACY_SERIALIZER.serialize(message);
        String processedString = MessageProcessor.process(legacyString);
        return LEGACY_SERIALIZER.deserialize(processedString);
    }

    @Generated
    private MessageProcessor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

