/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcspotifylink.utils;

import com.mongenscave.mcspotifylink.McSpotifyLink;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class LoggerUtils {
    private static final Logger logger = LogManager.getLogger((String)"McSpotifyLink");

    public static void info(@NotNull String msg, Object ... objs) {
        logger.info(msg, objs);
    }

    public static void warn(@NotNull String msg, Object ... objs) {
        logger.warn(msg, objs);
    }

    public static void error(@NotNull String msg, Object ... objs) {
        logger.error(msg, objs);
    }

    public static void printStartup() {
        String[] lines;
        String orange = "\\u001B[38;5;208m";
        String reset = "\u001b[0m";
        String software = McSpotifyLink.getInstance().getServer().getName();
        String version = McSpotifyLink.getInstance().getServer().getVersion();
        String asciiArt = orange + "  ______    _                _     " + reset + orange + " |  ____|  (_)              | |    " + reset + orange + " | |__ _ __ _  ___ _ __   __| |___ " + reset + orange + " |  __| '__| |/ _ \\ '_ \\ / _` / __|" + reset + orange + " | |  | |  | |  __/ | | | (_| \\__ \\" + reset + orange + " |_|  |_|  |_|\\___|_| |_|\\__,_|___/" + reset + orange + "\n                    |___/                       " + reset;
        LoggerUtils.info(" ", new Object[0]);
        for (String line : lines = asciiArt.split("\n")) {
            LoggerUtils.info(line, new Object[0]);
        }
        LoggerUtils.info(" ", new Object[0]);
        LoggerUtils.info("{}   The plugin successfully started.{}", orange, reset);
        LoggerUtils.info("{}   mc-PlayTime {} {}{}", orange, software, version, reset);
        LoggerUtils.info("{}   Discord @ dc.mongenscave.com{}", orange, reset);
        LoggerUtils.info(" ", new Object[0]);
    }

    @Generated
    private LoggerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

