/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcspotifylink.zapper;

import com.mongenscave.mcspotifylink.zapper.Dependency;
import com.mongenscave.mcspotifylink.zapper.relocation.Relocation;
import com.mongenscave.mcspotifylink.zapper.repository.Repository;
import com.mongenscave.mcspotifylink.zapper.util.ClassLoaderReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class RuntimeLibPluginConfiguration {
    @NotNull
    private final String libsFolder;
    @NotNull
    private final String relocationPrefix;
    @NotNull
    private final List<Dependency> dependencies;
    @NotNull
    private final List<Repository> repositories;
    @NotNull
    private final List<Relocation> relocations;

    RuntimeLibPluginConfiguration(@NotNull String libsFolder, @NotNull String relocationPrefix, @NotNull List<Dependency> dependencies, @NotNull List<Repository> repositories, @NotNull List<Relocation> relocations) {
        this.libsFolder = libsFolder;
        this.relocationPrefix = relocationPrefix;
        this.dependencies = dependencies;
        this.repositories = repositories;
        this.relocations = relocations;
    }

    @NotNull
    public static RuntimeLibPluginConfiguration parse() {
        try {
            Properties config = RuntimeLibPluginConfiguration.parseProperties();
            String libsFolder = config.getProperty("libs-folder");
            String relocationPrefix = config.getProperty("relocation-prefix");
            List<Repository> repositories = RuntimeLibPluginConfiguration.parseRepositories();
            List<Dependency> dependencies = RuntimeLibPluginConfiguration.parseDependencies();
            List<Relocation> relocations = RuntimeLibPluginConfiguration.parseRelocations();
            return new RuntimeLibPluginConfiguration(libsFolder, relocationPrefix, dependencies, repositories, relocations);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Generated Zapper files are missing. Have you applied the Gradle plugin?");
        }
    }

    @NotNull
    private static List<Relocation> parseRelocations() throws IOException {
        InputStream stream = ClassLoaderReader.getResource("zapper/relocations.txt");
        if (stream == null) {
            return Collections.emptyList();
        }
        ArrayList<Relocation> relocations = new ArrayList<Relocation>();
        for (String line : RuntimeLibPluginConfiguration.readAllLines(stream)) {
            String[] split = line.split(":");
            relocations.add(new Relocation(split[0], split[1]));
        }
        return relocations;
    }

    @NotNull
    private static List<Dependency> parseDependencies() {
        InputStream stream = ClassLoaderReader.getResource("zapper/dependencies.txt");
        if (stream == null) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (String line : RuntimeLibPluginConfiguration.readAllLines(stream)) {
            String[] split = line.split(":");
            dependencies.add(new Dependency(split[0], split[1], split[2]));
        }
        return dependencies;
    }

    @NotNull
    private static List<Repository> parseRepositories() {
        InputStream stream = ClassLoaderReader.getResource("zapper/repositories.txt");
        if (stream == null) {
            return Collections.emptyList();
        }
        ArrayList<Repository> repos = new ArrayList<Repository>();
        for (String line : RuntimeLibPluginConfiguration.readAllLines(stream)) {
            repos.add(Repository.maven(line));
        }
        return repos;
    }

    @NotNull
    private static Properties parseProperties() {
        Properties properties = new Properties();
        try (InputStream stream = ClassLoaderReader.getResource("zapper/zapper.properties");){
            properties.load(stream);
        }
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static List<String> readAllLines(@NotNull InputStream inputStream) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
    }

    @NotNull
    public String getLibsFolder() {
        return this.libsFolder;
    }

    @NotNull
    public String getRelocationPrefix() {
        return this.relocationPrefix;
    }

    @NotNull
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    @NotNull
    public List<Repository> getRepositories() {
        return this.repositories;
    }

    @NotNull
    public List<Relocation> getRelocations() {
        return this.relocations;
    }

    public String toString() {
        return "RuntimeLibPluginConfiguration(libsFolder=" + this.getLibsFolder() + ", relocationPrefix=" + this.getRelocationPrefix() + ", dependencies=" + this.getDependencies() + ", repositories=" + this.getRepositories() + ", relocations=" + this.getRelocations() + ")";
    }
}

