/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.padoru.client.model;

import com.mrbysco.padoru.client.model.PadoruAnimation;
import com.mrbysco.padoru.client.state.PadoruRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class PadoruModel
extends EntityModel<PadoruRenderState> {
    private final ModelPart head;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final KeyframeAnimation spinAnimation;

    public PadoruModel(ModelPart part) {
        super(part);
        ModelPart root = part.getChild("root");
        this.head = root.getChild("head");
        this.rightArm = root.getChild("right_arm");
        this.leftArm = root.getChild("left_arm");
        this.rightLeg = root.getChild("right_leg");
        this.leftLeg = root.getChild("left_leg");
        this.spinAnimation = PadoruAnimation.PADORU_SPIN.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -7.0f, -4.25f, 7.0f, 7.0f, 8.0f).texOffs(22, 0).addBox(-2.5f, -5.0f, 2.75f, 5.0f, 3.0f, 3.0f), PartPose.offset((float)-0.5f, (float)-11.0f, (float)0.25f));
        PartDefinition bow = head.addOrReplaceChild("bow", CubeListBuilder.create().texOffs(30, 11).addBox(-1.5f, -1.0f, 0.0f, 3.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.75f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bow_strings = bow.addOrReplaceChild("bow_strings", CubeListBuilder.create().texOffs(30, 8).addBox(-3.5f, -1.0f, 0.5f, 3.0f, 2.0f, 1.0f).texOffs(30, 14).addBox(0.5f, -1.0f, 0.5f, 3.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)1.75f, (float)0.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition hat = head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(0, 15).addBox(-2.7835f, -0.8131f, -1.897f, 6.0f, 2.0f, 6.0f).texOffs(0, 23).addBox(-1.3583f, -2.7185f, -1.6765f, 4.0f, 2.0f, 4.0f).texOffs(0, 29).addBox(1.1417f, -3.9685f, -2.4265f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.9554f, (float)-7.0602f, (float)-3.2478f, (float)0.0873f, (float)0.0873f, (float)0.1745f));
        PartDefinition right_arm = root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 51).addBox(-4.5f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-3.9008f, (float)-8.3392f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition left_arm = root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 45).addBox(-0.5f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)2.8055f, (float)-8.581f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition skirt = root.addOrReplaceChild("skirt", CubeListBuilder.create().texOffs(38, 47).addBox(-3.5f, -6.0f, -3.0f, 7.0f, 3.0f, 6.0f).texOffs(40, 13).addBox(-5.5f, 0.0f, -5.0f, 2.0f, 3.0f, 10.0f).texOffs(40, 0).addBox(3.5f, 0.0f, -5.0f, 2.0f, 3.0f, 10.0f).texOffs(46, 26).addBox(-3.5f, 0.0f, 3.0f, 7.0f, 3.0f, 2.0f).texOffs(46, 31).addBox(-3.5f, 0.0f, -5.0f, 7.0f, 3.0f, 2.0f).texOffs(30, 36).addBox(-4.5f, -3.0f, -4.0f, 9.0f, 3.0f, 8.0f), PartPose.offset((float)-0.5f, (float)-5.0f, (float)0.0f));
        PartDefinition left_leg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 57).addBox(-1.0f, 0.5f, -1.0f, 2.0f, 5.0f, 2.0f), PartPose.offset((float)1.0f, (float)-5.5f, (float)0.0f));
        PartDefinition right_leg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(10, 57).addBox(-1.0f, 0.5f, -1.0f, 2.0f, 5.0f, 2.0f), PartPose.offset((float)-2.0f, (float)-5.5f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(PadoruRenderState renderState) {
        super.setupAnim((Object)renderState);
        this.animateHeadLookTarget(renderState.yRot, renderState.xRot);
        this.animateWalk(renderState.walkAnimationPos, renderState.walkAnimationSpeed);
        this.spinAnimation.apply(renderState.spinAnimationState, renderState.ageInTicks);
    }

    private void animateHeadLookTarget(float headPitch, float netHeadYaw) {
        this.head.xRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.yRot = headPitch * ((float)Math.PI / 180);
    }

    private void animateWalk(float limbSwing, float limbSwingAmount) {
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftLeg.yRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.rightLeg.yRot = 0.0f;
    }
}

