/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.padoru.client.render;

import com.mrbysco.padoru.client.ClientHandler;
import com.mrbysco.padoru.client.model.PadoruModel;
import com.mrbysco.padoru.client.state.PadoruRenderState;
import com.mrbysco.padoru.entity.Padoru;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PadoruRenderer
extends MobRenderer<Padoru, PadoruRenderState, PadoruModel> {
    private static final ResourceLocation PADORU_TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"padoru", (String)"textures/entity/padoru.png");

    public PadoruRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PadoruModel(context.bakeLayer(ClientHandler.PADORU)), 0.25f);
    }

    public Vec3 getRenderOffset(PadoruRenderState renderState) {
        return super.getRenderOffset((EntityRenderState)renderState).add(0.0, -1.5, 0.0);
    }

    public PadoruRenderState createRenderState() {
        return new PadoruRenderState();
    }

    public void extractRenderState(Padoru padoru, PadoruRenderState renderState, float partialTick) {
        super.extractRenderState((LivingEntity)padoru, (LivingEntityRenderState)renderState, partialTick);
        renderState.spinAnimationState.copyFrom(padoru.spinAnimationState);
    }

    @NotNull
    public ResourceLocation getTextureLocation(PadoruRenderState renderState) {
        return PADORU_TEXTURES;
    }
}

