/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.padoru.datagen;

import com.mrbysco.padoru.datagen.client.ModLanguageProvider;
import com.mrbysco.padoru.datagen.client.ModModelProvider;
import com.mrbysco.padoru.datagen.client.ModSoundProvider;
import com.mrbysco.padoru.datagen.server.ModBiomeTags;
import com.mrbysco.padoru.datagen.server.ModLootProvider;
import com.mrbysco.padoru.init.ModRegistry;
import com.mrbysco.padoru.init.ModTags;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Cloner;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.Weighted;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class PadoruDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(PadoruDataGen::getProvider), Set.of("padoru")));
        generator.addProvider(true, (DataProvider)new ModLootProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new ModBiomeTags(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new ModLanguageProvider(packOutput));
        generator.addProvider(true, (DataProvider)new ModModelProvider(packOutput));
        generator.addProvider(true, (DataProvider)new ModSoundProvider(packOutput));
    }

    private static RegistrySetBuilder.PatchedRegistries getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, context -> {
            HolderGetter biomeHolderGetter = context.lookup(Registries.BIOME);
            BiomeModifiers.AddSpawnsBiomeModifier addSpawn = BiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)biomeHolderGetter.getOrThrow(ModTags.CAN_SPAWN_NERO_CLAUDIUS), (Weighted)new Weighted((Object)new MobSpawnSettings.SpawnerData(ModRegistry.PADORU.get(), 1, 4), 2));
            context.register(PadoruDataGen.createKey("add_padoru_spawn"), (Object)addSpawn);
        });
        registryBuilder.add(Registries.BIOME, $ -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        Cloner.Factory cloner$factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(data -> data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)cloner$factory).addCodec(arg_0, arg_1)));
        return registryBuilder.buildPatch((RegistryAccess)regAccess, VanillaRegistries.createLookup(), cloner$factory);
    }

    private static ResourceKey<BiomeModifier> createKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"padoru", (String)name));
    }
}

