/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.padoru.entity;

import com.mrbysco.padoru.entity.Padoru;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;

public class FollowPlayerGoal
extends Goal {
    protected final Padoru padoru;
    private Player player;
    private final double followSpeed;
    private final PathNavigation navigator;
    private int timeToRecalcPath;
    private final float maxDist;
    private final float minDist;
    private float oldWaterCost;

    public FollowPlayerGoal(Padoru padoru, double followSpeedIn, float minDistIn, float maxDistIn) {
        this.padoru = padoru;
        this.followSpeed = followSpeedIn;
        this.navigator = padoru.getNavigation();
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(padoru.getNavigation() instanceof GroundPathNavigation) && !(padoru.getNavigation() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowplayerGoal");
        }
    }

    public boolean canUse() {
        Player nearestPlayer = this.padoru.getNearestPlayer();
        if (nearestPlayer == null) {
            return false;
        }
        if (nearestPlayer.isSpectator()) {
            return false;
        }
        this.player = nearestPlayer;
        return true;
    }

    public boolean canContinueToUse() {
        return !this.navigator.isDone() && this.padoru.distanceToSqr((Entity)this.player) > (double)(this.maxDist * this.maxDist);
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.padoru.getPathfindingMalus(PathType.WATER);
        this.padoru.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.player = null;
        this.navigator.stop();
        this.padoru.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        this.padoru.getLookControl().setLookAt((Entity)this.player, 10.0f, (float)this.padoru.getMaxHeadXRot());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!(this.navigator.moveTo((Entity)this.player, this.followSpeed) || this.padoru.isLeashed() || this.padoru.isPassenger() || this.padoru.distanceToSqr((Entity)this.player) < 144.0)) {
                int i = Mth.floor((double)this.player.getX()) - 2;
                int j = Mth.floor((double)this.player.getZ()) - 2;
                int k = Mth.floor((double)this.player.getBoundingBox().minY);
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.canTeleportToBlock(new BlockPos(i + l, k - 1, j + i1))) continue;
                        this.padoru.snapTo((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.padoru.getYRot(), this.padoru.getXRot());
                        this.navigator.stop();
                        return;
                    }
                }
            }
        }
    }

    protected boolean canTeleportToBlock(BlockPos pos) {
        Level level = this.padoru.level();
        BlockState blockstate = level.getBlockState(pos);
        return blockstate.isValidSpawn((BlockGetter)level, pos, this.padoru.getType()) && level.isEmptyBlock(pos.above()) && level.isEmptyBlock(pos.above(2));
    }
}

