/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.padoru.entity;

import com.mrbysco.padoru.entity.FollowPlayerGoal;
import com.mrbysco.padoru.init.ModRegistry;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class Padoru
extends PathfinderMob {
    public AnimationState spinAnimationState = new AnimationState();

    public Padoru(EntityType<? extends Padoru> type, Level level) {
        super(type, level);
    }

    public Padoru(Level level) {
        super(ModRegistry.PADORU.get(), level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new FollowPlayerGoal(this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
    }

    protected float getSoundVolume() {
        return super.getSoundVolume();
    }

    public float getVoicePitch() {
        return 1.0f;
    }

    @Nullable
    public SoundEvent getAmbientSound() {
        if (this.getPose() == Pose.EMERGING) {
            return null;
        }
        return (SoundEvent)ModRegistry.PADORU_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)ModRegistry.PADORU_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModRegistry.PADORU_DEATH.get();
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Padoru.createMobAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public Player getNearestPlayer() {
        AABB aabb = new AABB(this.getX(), this.getY(), this.getZ(), this.getX() + 1.0, this.getY() + 1.0, this.getZ() + 1.0).inflate(8.0);
        List list = this.level().getEntitiesOfClass(Player.class, aabb);
        return !list.isEmpty() ? (Player)list.get(0) : null;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        if (DATA_POSE.equals(dataAccessor) && this.getPose() == Pose.EMERGING) {
            this.spinAnimationState.start(this.tickCount);
        }
        super.onSyncedDataUpdated(dataAccessor);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity, this.hasPose(Pose.EMERGING) ? 1 : 0);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket clientboundAddEntityPacket) {
        super.recreateFromPacket(clientboundAddEntityPacket);
        if (clientboundAddEntityPacket.getData() == 1) {
            this.setPose(Pose.EMERGING);
        }
    }

    public void tick() {
        super.tick();
        if (this.spinAnimationState.isStarted() && this.spinAnimationState.getTimeInMillis((float)this.tickCount) > 9000L) {
            this.spinAnimationState.stop();
            if (this.getPose() == Pose.EMERGING) {
                this.setPose(Pose.STANDING);
            }
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, EntitySpawnReason spawnReason, @Nullable SpawnGroupData groupData) {
        SpawnGroupData data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnReason, groupData);
        this.setPose(Pose.EMERGING);
        this.getBrain().setMemoryWithExpiry(MemoryModuleType.IS_EMERGING, (Object)Unit.INSTANCE, 100L);
        this.playSound((SoundEvent)ModRegistry.PADORU_SPAWN.get(), 1.0f, 1.0f);
        return data;
    }
}

