/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.core.command.util;

import org.geysermc.floodgate.core.command.util.PermissionDefault;

public enum Permission {
    COMMAND_MAIN("floodgate.command.floodgate", PermissionDefault.TRUE),
    COMMAND_MAIN_FIREWALL(COMMAND_MAIN, "firewall", PermissionDefault.OP),
    COMMAND_MAIN_VERSION(COMMAND_MAIN, "version", PermissionDefault.OP),
    COMMAND_LINK("floodgate.command.linkaccount", PermissionDefault.TRUE),
    COMMAND_UNLINK("floodgate.command.unlinkaccount", PermissionDefault.TRUE),
    COMMAND_WHITELIST("floodgate.command.fwhitelist", PermissionDefault.OP),
    NEWS_RECEIVE("floodgate.news.receive", PermissionDefault.OP);

    private final String permission;
    private final PermissionDefault defaultValue;

    private Permission(String permission, PermissionDefault defaultValue) {
        this.permission = permission;
        this.defaultValue = defaultValue;
    }

    private Permission(Permission parent, String child, PermissionDefault defaultValue) {
        this(parent.get() + "." + child, defaultValue);
    }

    public String get() {
        return this.permission;
    }

    public PermissionDefault defaultValue() {
        return this.defaultValue;
    }
}

