/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.core.config;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.util.UUID;
import org.geysermc.configutils.ConfigUtilities;
import org.geysermc.configutils.file.codec.PathFileCodec;
import org.geysermc.configutils.file.template.TemplateReader;
import org.geysermc.configutils.updater.change.Changes;
import org.geysermc.floodgate.core.config.FloodgateConfig;
import org.geysermc.floodgate.core.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.crypto.FloodgateCipher;
import org.geysermc.floodgate.crypto.KeyProducer;

public final class ConfigLoader {
    private final Path dataDirectory;
    private final Class<? extends FloodgateConfig> configClass;
    private final KeyProducer keyProducer;
    private final FloodgateCipher cipher;
    private final TemplateReader reader;

    public <T extends FloodgateConfig> T load() {
        String templateFile = "config.yml";
        if (ProxyFloodgateConfig.class.isAssignableFrom(this.configClass)) {
            templateFile = "proxy-" + templateFile;
        }
        ConfigUtilities utilities = ConfigUtilities.builder().fileCodec(PathFileCodec.of(this.dataDirectory)).configFile("config.yml").templateReader(this.reader).template(templateFile).changes(Changes.builder().version(1, Changes.versionBuilder().keyRenamed("player-link.enable", "player-link.enabled").keyRenamed("player-link.allow-linking", "player-link.allowed")).version(2, Changes.versionBuilder().keyRenamed("player-link.use-global-linking", "player-link.enable-global-linking")).build()).definePlaceholder("metrics.uuid", UUID::randomUUID).postInitializeCallbackArgument(this).build();
        try {
            return (T)utilities.executeOn(this.configClass);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Failed to load the config! Try to delete the config file if this error persists", throwable);
        }
    }

    public void generateKey(Path keyPath) {
        try {
            Key key = this.keyProducer.produce();
            this.cipher.init(key);
            String test = "abcdefghijklmnopqrstuvwxyz0123456789";
            byte[] encrypted = this.cipher.encryptFromString(test);
            String decrypted = this.cipher.decryptToString(encrypted);
            if (!test.equals(decrypted)) {
                throw new RuntimeException("Failed to decrypt test message.\nOriginal message: " + test + ".Decrypted message: " + decrypted + ".\nThe encrypted message itself: " + new String(encrypted));
            }
            Files.write(keyPath, key.getEncoded(), new OpenOption[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while creating key", exception);
        }
    }

    public Path getDataDirectory() {
        return this.dataDirectory;
    }

    public Class<? extends FloodgateConfig> getConfigClass() {
        return this.configClass;
    }

    public KeyProducer getKeyProducer() {
        return this.keyProducer;
    }

    public FloodgateCipher getCipher() {
        return this.cipher;
    }

    public TemplateReader getReader() {
        return this.reader;
    }

    public ConfigLoader(Path dataDirectory, Class<? extends FloodgateConfig> configClass, KeyProducer keyProducer, FloodgateCipher cipher, TemplateReader reader) {
        this.dataDirectory = dataDirectory;
        this.configClass = configClass;
        this.keyProducer = keyProducer;
        this.cipher = cipher;
        this.reader = reader;
    }
}

