/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.core.pluginmessage;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.geysermc.floodgate.core.pluginmessage.PluginMessageChannel;
import org.geysermc.floodgate.shadow.google.inject.Inject;

public class PluginMessageManager {
    private final Map<Class<? extends PluginMessageChannel>, PluginMessageChannel> classInstanceMap = new HashMap<Class<? extends PluginMessageChannel>, PluginMessageChannel>();
    private final Map<String, PluginMessageChannel> identifierInstanceMap = new HashMap<String, PluginMessageChannel>();

    @Inject
    public void addChannels(Set<PluginMessageChannel> channels) {
        if (!this.classInstanceMap.isEmpty()) {
            return;
        }
        for (PluginMessageChannel channel : channels) {
            this.classInstanceMap.put(channel.getClass(), channel);
            this.identifierInstanceMap.put(channel.getIdentifier(), channel);
        }
    }

    public <T extends PluginMessageChannel> T getChannel(Class<T> channelType) {
        return (T)this.classInstanceMap.get(channelType);
    }

    public PluginMessageChannel getChannel(String identifier) {
        return this.identifierInstanceMap.get(identifier);
    }
}

