/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.core.util;

import com.google.common.base.Joiner;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.core.config.FloodgateConfig;
import org.geysermc.floodgate.core.util.Utils;
import org.geysermc.floodgate.shadow.google.inject.Inject;
import org.geysermc.floodgate.shadow.google.inject.Singleton;

@Singleton
public final class LanguageManager {
    private final Map<String, Properties> localeMappings = new HashMap<String, Properties>();
    @Inject
    private FloodgateConfig config;
    @Inject
    private FloodgateLogger logger;
    private String defaultLocale;

    private static String formatLocale(String locale) {
        try {
            String[] parts = locale.toLowerCase(Locale.ROOT).split("_");
            return parts[0] + "_" + parts[1].toUpperCase(Locale.ROOT);
        }
        catch (Exception e) {
            return locale;
        }
    }

    @Inject
    private void init() {
        String systemLocale;
        if (!this.loadLocale("en_US")) {
            this.logger.error("Failed to load the fallback language. This will likely cause errors!", new Object[0]);
        }
        this.defaultLocale = LanguageManager.formatLocale(this.config.getDefaultLocale());
        if (this.isValidLanguage(this.defaultLocale)) {
            if (this.loadLocale(this.defaultLocale)) {
                return;
            }
            this.logger.warn("Language provided in the config wasn't found. Will use system locale.", new Object[0]);
        }
        if (this.isValidLanguage(systemLocale = LanguageManager.formatLocale(Utils.getLocale(Locale.getDefault())))) {
            if (this.loadLocale(systemLocale)) {
                this.defaultLocale = systemLocale;
                return;
            }
            this.logger.warn("Language file for system locale wasn't found. Falling back to en_US", new Object[0]);
        }
        this.defaultLocale = "en_US";
    }

    public boolean loadLocale(String locale) {
        String formatLocale = LanguageManager.formatLocale(locale);
        if (this.localeMappings.containsKey(formatLocale)) {
            return true;
        }
        Properties properties = Utils.readProperties("languages/texts/" + formatLocale + ".properties");
        if (properties != null) {
            this.localeMappings.put(formatLocale, properties);
            return true;
        }
        this.logger.warn("Missing locale file: " + formatLocale, new Object[0]);
        return false;
    }

    public String getLogString(String key, Object ... values) {
        return this.getString(key, this.defaultLocale, values);
    }

    public String getString(String key, String locale, Object ... values) {
        Properties properties = this.localeMappings.get(locale);
        String formatString = null;
        if (properties != null) {
            formatString = properties.getProperty(key);
        }
        if (formatString == null) {
            properties = this.localeMappings.get(this.defaultLocale);
            formatString = properties.getProperty(key);
        }
        if (formatString == null) {
            return this.formatNotFound(key, values);
        }
        return MessageFormat.format(formatString.replace("'", "''").replace("&", "\u00a7"), values);
    }

    private boolean isValidLanguage(String locale) {
        if (locale == null) {
            return false;
        }
        URL languageFile = LanguageManager.class.getResource("/languages/texts/" + locale + ".properties");
        if (languageFile == null) {
            this.logger.warn(locale + " is not a supported Floodgate language.", new Object[0]);
            return false;
        }
        return true;
    }

    private String formatNotFound(String key, Object ... args) {
        return key + " " + Joiner.on((String)", ").join(args);
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }
}

